/*
 * Decompiled with CFR 0.152.
 */
package com.afox.elementaryequipment.ability.active;

import com.afox.elementaryequipment.events.DelayedTaskScheduler;
import com.afox.elementaryequipment.utils.EffectsUtils;
import com.afox.elementaryequipment.utils.EntityUtils;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1291;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2404;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5689;
import net.minecraft.class_5691;
import net.minecraft.class_5819;

public class MountainSwordActiveAbility {
    private static final int RADIUS = 16;
    private static final float UPWARD_VELOCITY = 1.6f;
    private static final int EFFECT_DURATION = 160;
    private static final List<class_5691> THICKNESS_LIST = List.of(class_5691.field_28065, class_5691.field_28066, class_5691.field_28067);

    public static void execute(class_1937 world, class_1657 player) {
        if (world.method_8608()) {
            return;
        }
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            List<class_1309> livingEntities = EntityUtils.getEntitiesInArea((class_1937)serverWorld, player.method_19538(), 16.0);
            List<class_1309> hostileEntities = EntityUtils.FilterEntity.getEntitiesInScopes(livingEntities, player);
            MountainSwordActiveAbility.playSound(serverWorld, player);
            hostileEntities.forEach(entity -> {
                class_2338 blockPos = entity.method_24515();
                MountainSwordActiveAbility.spawnPointedDripstone(serverWorld, blockPos, player);
                MountainSwordActiveAbility.applyEffectsToEntities(entity);
                entity.method_18799(entity.method_18798().method_1031(0.0, (double)1.6f, 0.0));
                entity.field_6037 = true;
            });
        }
    }

    private static void spawnPointedDripstone(class_3218 serverWorld, class_2338 blockPos, class_1657 player) {
        for (int dx = -2; dx <= 2; ++dx) {
            for (int dy = -3; dy <= 3; ++dy) {
                for (int dz = -2; dz <= 2; ++dz) {
                    class_2338 spawnPos;
                    if (dx == 0 && dz == 0 || !MountainSwordActiveAbility.isValidPosition(serverWorld, (spawnPos = blockPos.method_10069(dx, dy, dz)).method_10074())) continue;
                    class_5819 random = serverWorld.method_8409();
                    int height = random.method_43056() ? 1 : 2;
                    int delay = 5 + random.method_43048(4) * 3;
                    DelayedTaskScheduler.schedule(delay, () -> MountainSwordActiveAbility.placeDripstones(serverWorld, player, spawnPos, height));
                }
            }
        }
        if (MountainSwordActiveAbility.isValidPosition(serverWorld, blockPos.method_10074())) {
            DelayedTaskScheduler.schedule(5, () -> MountainSwordActiveAbility.placeDripstones(serverWorld, player, blockPos, THICKNESS_LIST.size()));
        }
    }

    private static boolean isValidPosition(class_3218 serverWorld, class_2338 pos) {
        class_2680 state = serverWorld.method_8320(pos);
        return state.method_26234((class_1922)serverWorld, pos) && !(state.method_26204() instanceof class_2404);
    }

    private static void placeDripstones(class_3218 serverWorld, class_1657 player, class_2338 basePos, int height) {
        for (int i = 0; i < height; ++i) {
            class_2338 pos = basePos.method_10086(i);
            class_2680 state = serverWorld.method_8320(pos);
            if (!state.method_45474() && !serverWorld.method_22351(pos)) {
                return;
            }
            class_5691 thickness = THICKNESS_LIST.get(i);
            serverWorld.method_8501(pos, MountainSwordActiveAbility.createDripstoneState(serverWorld, pos, thickness));
        }
        MountainSwordActiveAbility.placeDristoneSound(serverWorld, player);
        MountainSwordActiveAbility.spawnParticles(serverWorld, basePos);
    }

    private static class_2680 createDripstoneState(class_3218 serverWorld, class_2338 blockPos, class_5691 thickness) {
        return (class_2680)((class_2680)((class_2680)class_2246.field_28048.method_9564().method_11657((class_2769)class_5689.field_28050, (Comparable)class_2350.field_11036)).method_11657((class_2769)class_5689.field_28051, (Comparable)thickness)).method_11657((class_2769)class_5689.field_28052, (Comparable)Boolean.valueOf(serverWorld.method_22351(blockPos)));
    }

    private static void placeDristoneSound(class_3218 serverWorld, class_1657 player) {
        serverWorld.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_15026, class_3419.field_15245, 1.5f, 0.3f);
    }

    private static void playSound(class_3218 serverWorld, class_1657 player) {
        serverWorld.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), (class_3414)class_3417.field_22456.comp_349(), class_3419.field_15256, 1.5f, 1.0f);
    }

    private static void spawnParticles(class_3218 serverWorld, class_2338 blockPos) {
        serverWorld.method_14199((class_2394)new class_2388(class_2398.field_11217, class_2246.field_28048.method_9564()), (double)blockPos.method_10263() + 0.5, (double)blockPos.method_10264(), (double)blockPos.method_10260() + 0.5, 25, 0.3, 0.3, 0.3, 0.1);
    }

    private static void applyEffectsToEntities(class_1309 livingEntity) {
        Map<class_1291, Integer> effects = Map.of(class_1294.field_5899, 1, class_1294.field_5909, 4, class_1294.field_5911, 2);
        EffectsUtils.applyEffectsToEntity(livingEntity, effects, 160);
    }
}

