/*
 * Decompiled with CFR 0.152.
 */
package com.t2pellet.haybale.forge.registry;

import com.t2pellet.haybale.Services;
import com.t2pellet.haybale.common.network.api.Packet;
import com.t2pellet.haybale.common.registry.api.EntityEntryType;
import com.t2pellet.haybale.common.registry.api.ItemEntryType;
import com.t2pellet.haybale.common.registry.api.ParticleEntryType;
import com.t2pellet.haybale.common.registry.api.SoundEntryType;
import com.t2pellet.haybale.common.utils.VersionHelper;
import com.t2pellet.haybale.forge.HaybaleForge;
import com.t2pellet.haybale.forge.HaybaleForgeMod;
import com.t2pellet.haybale.forge.network.PacketHandler;
import com.t2pellet.haybale.registry.ICommonRegistry;
import java.util.function.Supplier;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.Item;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.RegistryObject;

public class CommonRegistry
implements ICommonRegistry {
    @Override
    public Supplier<SimpleParticleType> register(String modid, ParticleEntryType particleEntryType) {
        HaybaleForgeMod forgeMod = HaybaleForge.getInstance().get(modid);
        return forgeMod.PARTICLES.register(particleEntryType.getName(), () -> new SimpleParticleType(true));
    }

    @Override
    public <T extends LivingEntity> Supplier<EntityType<T>> register(String modid, EntityEntryType<T> entityEntryType) {
        HaybaleForgeMod forgeMod = HaybaleForge.getInstance().get(modid);
        RegistryObject result = forgeMod.ENTITIES.register(entityEntryType.getName(), () -> EntityType.Builder.m_20704_(entityEntryType.getFactory(), (MobCategory)entityEntryType.getMobCategory()).m_20702_(48).m_20717_(3).m_20699_(entityEntryType.getWidth(), entityEntryType.getHeight()).m_20712_(entityEntryType.getName()));
        FMLJavaModLoadingContext.get().getModEventBus().addListener(event -> event.put((EntityType)result.get(), entityEntryType.buildAttributes().m_22265_()));
        return result;
    }

    @Override
    public Supplier<SoundEvent> register(String modid, SoundEntryType soundEntryType) {
        ResourceLocation location = VersionHelper.getResourceLocation(modid, soundEntryType.getName());
        HaybaleForgeMod forgeMod = HaybaleForge.getInstance().get(modid);
        return forgeMod.SOUNDS.register(soundEntryType.getName(), () -> SoundEvent.m_262824_((ResourceLocation)location));
    }

    @Override
    public Supplier<Item> register(String modid, ItemEntryType itemEntryType) {
        HaybaleForgeMod forgeMod = HaybaleForge.getInstance().get(modid);
        return forgeMod.ITEMS.register(itemEntryType.getName(), () -> new Item(itemEntryType.getProperties()));
    }

    @Override
    public void registerServerPacket(String modid, String name, Class<? extends Packet> packetClass) {
        PacketHandler packetHandler = (PacketHandler)Services.PACKET_HANDLER;
        packetHandler.registerServerPacket(modid, name, packetClass);
    }

    @Override
    public void registerClientPacket(String modid, String name, Class<? extends Packet> packetClass) {
        PacketHandler packetHandler = (PacketHandler)Services.PACKET_HANDLER;
        packetHandler.registerClientPacket(modid, name, packetClass);
    }
}

