/*
 * Decompiled with CFR 0.152.
 */
package com.t2pellet.haybale.neoforge.services;

import com.t2pellet.haybale.services.ISidedExecutor;
import java.util.PriorityQueue;
import net.minecraft.client.Minecraft;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;

public class SidedExecutor
implements ISidedExecutor {
    private final PriorityQueue<PQEntry> pq = new PriorityQueue();
    private long tick = 0L;

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void scheduleClient(Runnable runnable) {
        Minecraft.getInstance().execute(runnable);
    }

    @Override
    public void scheduleServer(Runnable runnable) {
        ServerLifecycleHooks.getCurrentServer().execute(runnable);
    }

    @Override
    public void scheduleServer(int ticks, Runnable runnable) {
        this.pq.add(new PQEntry(runnable, this.tick + (long)ticks));
    }

    public void onServerTick(ServerTickEvent.Post event) {
        ++this.tick;
        PQEntry top = this.pq.peek();
        if (top != null && top.tick >= this.tick) {
            this.pq.poll();
            event.getServer().execute(top.runnable);
        }
    }

    static class PQEntry
    implements Comparable<PQEntry> {
        private final Runnable runnable;
        private final Long tick;

        public PQEntry(Runnable runnable, long tick) {
            this.runnable = runnable;
            this.tick = tick;
        }

        @Override
        public int compareTo(@NotNull PQEntry o) {
            return this.tick.compareTo(o.tick);
        }
    }
}

