package com.t2pellet.haybale.common.network.capability;

import com.t2pellet.haybale.common.capability.api.Capability;
import com.t2pellet.haybale.common.capability.api.ICapabilityHaver;
import com.t2pellet.haybale.common.network.api.Packet;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;

public class CapabilityPacket<E extends Entity & ICapabilityHaver> extends Packet {

    private E capabilityHaver;
    private final Class<? extends Capability> clazz;

    public CapabilityPacket(E capabilityHaver, Class<? extends Capability> clazz) {
        super();
        this.capabilityHaver = capabilityHaver;
        this.clazz = (Class<? extends Capability>) clazz.getInterfaces()[0];
    }

    public CapabilityPacket(FriendlyByteBuf byteBuf) throws ClassNotFoundException {
        super(byteBuf);
        String classStr = tag.m_128461_("class")/*? if >= 1.21.5 {*//*.orElseThrow()*//*?}*/;
        this.clazz = (Class<? extends Capability>) Class.forName(classStr);
    }

    @Override
    public Runnable getExecutor() {
        return () -> {
            Tag data = tag.m_128423_("data");
            int id = tag.m_128451_("entity")/*? if >= 1.21.5 {*//*.orElseThrow()*//*?}*/;
            this.capabilityHaver = (E) Minecraft.m_91087_().f_91073_.m_6815_(id);
            if (this.capabilityHaver != null) {
                capabilityHaver.getCapabilityManager().getCapability(clazz).readTag(data);
            }
        };
    }

    @Override
    public void encode(FriendlyByteBuf byteBuf) {
        Capability capability = capabilityHaver.getCapabilityManager().getCapability(clazz);
        tag.m_128405_("entity", capabilityHaver.m_19879_());
        tag.m_128359_("class", clazz.getName());
        tag.m_128365_("data", capability.writeTag());
        super.encode(byteBuf);
    }
}
