/*
 * Decompiled with CFR 0.152.
 */
package com.t2pellet.haybale.mixin;

import com.t2pellet.haybale.common.capability.api.ICapabilityHaver;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public class EntityMixin {
    @Inject(method={"readAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="TAIL")})
    public void readFromTag(CompoundTag tag, CallbackInfo ci) {
        Entity e = (Entity)this;
        if (e instanceof ICapabilityHaver) {
            ICapabilityHaver capabilityHaver = (ICapabilityHaver)e;
            if (tag.contains("capabilities")) {
                capabilityHaver.getCapabilityManager().readTag(tag.get("capabilities"));
            }
        }
    }

    @Inject(method={"addAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="TAIL")})
    public void writeToTag(CompoundTag tag, CallbackInfo ci) {
        Entity e = (Entity)this;
        if (e instanceof ICapabilityHaver) {
            ICapabilityHaver capabilityHaver = (ICapabilityHaver)e;
            Tag capabilityTag = capabilityHaver.getCapabilityManager().writeTag();
            tag.put("capabilities", capabilityTag);
        }
    }
}

