/*
 * Decompiled with CFR 0.152.
 */
package com.t2pellet.haybale.neoforge.network;

import com.t2pellet.haybale.Haybale;
import com.t2pellet.haybale.common.network.api.Packet;
import com.t2pellet.haybale.common.utils.VersionHelper;
import com.t2pellet.haybale.services.IPacketHandler;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.jetbrains.annotations.NotNull;

public class PacketHandler
implements IPacketHandler {
    private final String PROTOCOL_VERSION = "4";
    private final Map<String, Map<Class<? extends Packet>, ResourceLocation>> packetMap = new HashMap<String, Map<Class<? extends Packet>, ResourceLocation>>();
    private final Map<Class<? extends Packet>, ResourceLocation> packetFlatMap = new HashMap<Class<? extends Packet>, ResourceLocation>();

    private static <T extends Packet> StreamCodec<FriendlyByteBuf, NeoforgePacket<T>> getCodec(Class<T> packetClass, ResourceLocation id) {
        return StreamCodec.of((packetByteBuf, fabricPacket) -> fabricPacket.encode((FriendlyByteBuf)packetByteBuf), packetByteBuf -> {
            try {
                Packet packet = (Packet)packetClass.getDeclaredConstructor(FriendlyByteBuf.class).newInstance(packetByteBuf);
                return new NeoforgePacket<Packet>(packet, id);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                Haybale.LOG.error("Error: Failed to instantiate packet - " + String.valueOf(id));
                return null;
            }
        });
    }

    public void registerPackets(RegisterPayloadHandlersEvent event) {
        Set<String> modIDs = this.packetMap.keySet();
        modIDs.forEach(modID -> {
            PayloadRegistrar registrar = event.registrar(modID).versioned("4").optional();
            Map<Class<? extends Packet>, ResourceLocation> packetClasses = this.packetMap.get(modID);
            packetClasses.forEach((packetClass, packetID) -> {
                CustomPacketPayload.Type type = new CustomPacketPayload.Type(packetID);
                registrar.playBidirectional(type, StreamCodec.of((packetByteBuf, packet) -> packet.encode((FriendlyByteBuf)packetByteBuf), packetByteBuf -> {
                    try {
                        Packet packet = (Packet)packetClass.getDeclaredConstructor(FriendlyByteBuf.class).newInstance(packetByteBuf);
                        return new NeoforgePacket<Packet>(packet, (ResourceLocation)packetID);
                    }
                    catch (ReflectiveOperationException e) {
                        Haybale.LOG.error("Error: Failed to instantiate packet - " + String.valueOf(packetID));
                        return null;
                    }
                }), (packet, context) -> context.enqueueWork(packet.executor()));
            });
        });
    }

    public void registerServerPacket(String modid, String name, Class<? extends Packet> packetClass) {
        ResourceLocation id = VersionHelper.getResourceLocation(modid, name);
        this.registerPacket(modid, packetClass, id);
    }

    public void registerClientPacket(String modid, String name, Class<? extends Packet> packetClass) {
        ResourceLocation id = VersionHelper.getResourceLocation(modid, name);
        this.registerPacket(modid, packetClass, id);
    }

    private void registerPacket(String modid, Class<? extends Packet> packetClass, ResourceLocation id) {
        if (this.packetMap.containsKey(modid)) {
            this.packetMap.get(modid).put(packetClass, id);
        } else {
            HashMap<Class<? extends Packet>, ResourceLocation> map = new HashMap<Class<? extends Packet>, ResourceLocation>();
            map.put(packetClass, id);
            this.packetMap.put(modid, map);
        }
        this.packetFlatMap.put(packetClass, id);
    }

    @Override
    public <T extends Packet> void sendToServer(T packet) {
        ResourceLocation id = this.packetFlatMap.get(packet.getClass());
        PacketDistributor.sendToServer(new NeoforgePacket<T>(packet, id), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public <T extends Packet> void sendTo(T packet, ServerPlayer player) {
        ResourceLocation id = this.packetFlatMap.get(packet.getClass());
        PacketDistributor.sendToPlayer((ServerPlayer)player, new NeoforgePacket<T>(packet, id), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public <T extends Packet> void sendTo(T packet, ServerPlayer ... players) {
        for (ServerPlayer player : players) {
            this.sendTo(packet, player);
        }
    }

    @Override
    public <T extends Packet> void sendInRange(T packet, Entity e, float range) {
        AABB box = new AABB(e.blockPosition()).inflate((double)range);
        this.sendInArea(packet, e.level(), box);
    }

    @Override
    public <T extends Packet> void sendInArea(T packet, Level world, AABB area) {
        ServerPlayer[] players = (ServerPlayer[])((ServerLevel)world).players().stream().filter(p -> area.contains(p.position())).toArray(ServerPlayer[]::new);
        this.sendTo(packet, players);
    }

    private static class NeoforgePacket<T extends Packet>
    implements CustomPacketPayload {
        private final T packet;
        private final CustomPacketPayload.Type<NeoforgePacket<T>> type;

        public NeoforgePacket(T packet, ResourceLocation id) {
            this.packet = packet;
            this.type = new CustomPacketPayload.Type(id);
        }

        @NotNull
        public CustomPacketPayload.Type<NeoforgePacket<T>> type() {
            return this.type;
        }

        public void encode(FriendlyByteBuf packetByteBuf) {
            ((Packet)this.packet).encode(packetByteBuf);
        }

        public Runnable executor() {
            return ((Packet)this.packet).getExecutor();
        }
    }
}

