/*
 * Decompiled with CFR 0.152.
 */
package com.t2pellet.haybale.forge.client;

import com.t2pellet.haybale.client.registry.IClientRegistry;
import com.t2pellet.haybale.client.registry.api.EntityModelEntryType;
import com.t2pellet.haybale.client.registry.api.EntityRendererEntryType;
import com.t2pellet.haybale.client.registry.api.ParticleFactoryEntryType;
import com.t2pellet.haybale.common.utils.VersionHelper;
import java.util.function.Supplier;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class ClientRegistry
implements IClientRegistry {
    @Override
    public Supplier<ParticleType<SimpleParticleType>> register(String modid, ParticleFactoryEntryType particleFactoryEntry) {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(particleFactoryRegisterEvent -> particleFactoryRegisterEvent.register(particleFactoryEntry.get(), spriteSet -> particleFactoryEntry.getProviderFunction().apply(spriteSet)));
        return particleFactoryEntry::get;
    }

    @Override
    public Supplier<ModelLayerLocation> register(String modid, EntityModelEntryType modelEntry) {
        Lazy locSupplier = () -> new ModelLayerLocation(VersionHelper.getResourceLocation(modid, modelEntry.getName()), "main");
        FMLJavaModLoadingContext.get().getModEventBus().addListener(event -> event.registerLayerDefinition((ModelLayerLocation)locSupplier.get(), modelEntry::getLayerDefinition));
        return locSupplier;
    }

    @Override
    public <T extends Entity> Supplier<EntityRendererProvider<T>> register(String modid, EntityRendererEntryType<T> rendererEntry) {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(event -> event.registerEntityRenderer(rendererEntry.getEntityType(), rendererEntry.getRendererProvider()));
        return rendererEntry::getRendererProvider;
    }
}

