/*
 * Decompiled with CFR 0.152.
 */
package com.t2pellet.haybale.common;

import com.t2pellet.haybale.client.registry.IClientRegistry;
import com.t2pellet.haybale.client.registry.api.EntityModelEntryType;
import com.t2pellet.haybale.client.registry.api.EntityRendererEntryType;
import com.t2pellet.haybale.client.registry.api.ParticleFactoryEntryType;
import com.t2pellet.haybale.common.BaseRegistrar;
import com.t2pellet.haybale.common.registry.api.EntryType;
import java.lang.reflect.Field;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import net.minecraft.class_2396;
import net.minecraft.class_5601;
import net.minecraft.class_5617;

public class ClientRegistrar
extends BaseRegistrar {
    public static final ClientRegistrar INSTANCE = new ClientRegistrar();
    private static final IClientRegistry CLIENT_REGISTRY = ServiceLoader.load(IClientRegistry.class).findFirst().orElseThrow(() -> new NullPointerException("Failed to load client registry service"));

    private ClientRegistrar() {
    }

    @Override
    protected boolean checkIsValid(Class<?> type) {
        return type.isAssignableFrom(class_5601.class) || type.isAssignableFrom(class_5617.class) || type.isAssignableFrom(class_2396.class);
    }

    @Override
    protected void doGenericRegistration(String modid, Class<?> registryType, Field declaredField) throws IllegalAccessException {
        EntryType entryType = (EntryType)declaredField.get(null);
        if (registryType.isAssignableFrom(entryType.type)) {
            Supplier<class_5601> result;
            if (entryType instanceof EntityModelEntryType) {
                EntityModelEntryType modelEntryType = (EntityModelEntryType)entryType;
                result = CLIENT_REGISTRY.register(modid, modelEntryType);
            } else if (entryType instanceof EntityRendererEntryType) {
                EntityRendererEntryType rendererEntryType = (EntityRendererEntryType)entryType;
                result = CLIENT_REGISTRY.register(modid, rendererEntryType);
            } else if (entryType instanceof ParticleFactoryEntryType) {
                ParticleFactoryEntryType particleFactoryEntryType = (ParticleFactoryEntryType)entryType;
                result = CLIENT_REGISTRY.register(modid, particleFactoryEntryType);
            } else {
                result = null;
            }
            this.setField("supplier", entryType, result);
        }
    }
}

