/*
 * Decompiled with CFR 0.152.
 */
package com.t2pellet.haybale.neoforge.client;

import com.t2pellet.haybale.client.registry.IClientRegistry;
import com.t2pellet.haybale.client.registry.api.EntityModelEntryType;
import com.t2pellet.haybale.client.registry.api.EntityRendererEntryType;
import com.t2pellet.haybale.client.registry.api.ParticleFactoryEntryType;
import com.t2pellet.haybale.common.utils.VersionHelper;
import com.t2pellet.haybale.neoforge.HaybaleNeoforge;
import com.t2pellet.haybale.neoforge.HaybaleNeoforgeMod;
import java.util.function.Supplier;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.common.util.Lazy;

public class ClientRegistry
implements IClientRegistry {
    @Override
    public Supplier<ParticleType<SimpleParticleType>> register(String modid, ParticleFactoryEntryType particleFactoryEntry) {
        HaybaleNeoforgeMod forgeMod = HaybaleNeoforge.getInstance().get(modid);
        forgeMod.modBus.addListener(particleFactoryRegisterEvent -> particleFactoryRegisterEvent.registerSpriteSet(particleFactoryEntry.get(), spriteSet -> particleFactoryEntry.getProviderFunction().apply(spriteSet)));
        return particleFactoryEntry::get;
    }

    @Override
    public Supplier<ModelLayerLocation> register(String modid, EntityModelEntryType modelEntry) {
        HaybaleNeoforgeMod forgeMod = HaybaleNeoforge.getInstance().get(modid);
        Lazy locSupplier = Lazy.of(() -> new ModelLayerLocation(VersionHelper.getResourceLocation(modid, modelEntry.getName()), "main"));
        forgeMod.modBus.addListener(event -> event.registerLayerDefinition((ModelLayerLocation)locSupplier.get(), modelEntry::getLayerDefinition));
        return locSupplier;
    }

    @Override
    public <T extends Entity> Supplier<EntityRendererProvider<T>> register(String modid, EntityRendererEntryType<T> rendererEntry) {
        HaybaleNeoforgeMod forgeMod = HaybaleNeoforge.getInstance().get(modid);
        forgeMod.modBus.addListener(event -> event.registerEntityRenderer(rendererEntry.getEntityType(), rendererEntry.getRendererProvider()));
        return rendererEntry::getRendererProvider;
    }
}

