/*
 * Decompiled with CFR 0.152.
 */
package com.t2pellet.haybale.neoforge.network;

import com.t2pellet.haybale.Haybale;
import com.t2pellet.haybale.common.network.api.Packet;
import com.t2pellet.haybale.common.utils.VersionHelper;
import com.t2pellet.haybale.services.IPacketHandler;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlerEvent;
import net.neoforged.neoforge.network.registration.IPayloadRegistrar;

public class PacketHandler
implements IPacketHandler {
    private final String PROTOCOL_VERSION = "4";
    private final Map<String, Map<Class<? extends Packet>, ResourceLocation>> packetMap = new HashMap<String, Map<Class<? extends Packet>, ResourceLocation>>();
    private final Map<Class<? extends Packet>, ResourceLocation> packetFlatMap = new HashMap<Class<? extends Packet>, ResourceLocation>();

    public void registerPackets(RegisterPayloadHandlerEvent event) {
        Set<String> modIDs = this.packetMap.keySet();
        modIDs.forEach(modID -> {
            IPayloadRegistrar registrar = event.registrar(modID).versioned("4").optional();
            Map<Class<? extends Packet>, ResourceLocation> packetClasses = this.packetMap.get(modID);
            packetClasses.forEach((packetClass, packetID) -> registrar.play(packetID, friendlyByteBuf -> {
                try {
                    final Packet packet = (Packet)packetClass.getDeclaredConstructor(FriendlyByteBuf.class).newInstance(friendlyByteBuf);
                    return new PacketPayloadWithExecutor(){
                        final /* synthetic */ ResourceLocation val$packetID;
                        {
                            this.val$packetID = resourceLocation;
                        }

                        @Override
                        public Runnable getExecutor() {
                            return packet.getExecutor();
                        }

                        public void write(FriendlyByteBuf arg) {
                            packet.encode(arg);
                        }

                        public ResourceLocation id() {
                            return this.val$packetID;
                        }
                    };
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                    Haybale.LOG.error("Error: Failed to instantiate packet - " + String.valueOf(packetID));
                    return null;
                }
            }, (t, contextSupplier) -> contextSupplier.workHandler().submitAsync(t.getExecutor())));
        });
    }

    public void registerServerPacket(String modid, String name, Class<? extends Packet> packetClass) {
        Map packetClasses = this.packetMap.getOrDefault(modid, new HashMap());
        ResourceLocation id = VersionHelper.getResourceLocation(modid, name);
        packetClasses.put(packetClass, id);
        this.packetFlatMap.put(packetClass, id);
    }

    public void registerClientPacket(String modid, String name, Class<? extends Packet> packetClass) {
        Map packetClasses = this.packetMap.getOrDefault(modid, new HashMap());
        ResourceLocation id = VersionHelper.getResourceLocation(modid, name);
        packetClasses.put(packetClass, id);
        this.packetFlatMap.put(packetClass, id);
    }

    @Override
    public <T extends Packet> void sendToServer(final T packet) {
        PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new CustomPacketPayload(){

            public void write(FriendlyByteBuf arg) {
                packet.encode(arg);
            }

            public ResourceLocation id() {
                return PacketHandler.this.packetFlatMap.get(packet.getClass());
            }
        }});
    }

    @Override
    public <T extends Packet> void sendTo(final T packet, ServerPlayer player) {
        PacketDistributor.PLAYER.with((Object)player).send(new CustomPacketPayload[]{new CustomPacketPayload(){

            public void write(FriendlyByteBuf arg) {
                packet.encode(arg);
            }

            public ResourceLocation id() {
                return PacketHandler.this.packetFlatMap.get(packet.getClass());
            }
        }});
    }

    @Override
    public <T extends Packet> void sendTo(T packet, ServerPlayer ... players) {
        for (ServerPlayer player : players) {
            this.sendTo(packet, player);
        }
    }

    @Override
    public <T extends Packet> void sendInRange(T packet, Entity e, float range) {
        AABB box = new AABB(e.blockPosition()).inflate((double)range);
        this.sendInArea(packet, e.level(), box);
    }

    @Override
    public <T extends Packet> void sendInArea(T packet, Level world, AABB area) {
        ServerPlayer[] players = (ServerPlayer[])((ServerLevel)world).players().stream().filter(p -> area.contains(p.position())).toArray(ServerPlayer[]::new);
        this.sendTo(packet, players);
    }

    private static interface PacketPayloadWithExecutor
    extends CustomPacketPayload {
        public Runnable getExecutor();
    }
}

