package com.t2pellet.haybale.common.capability.api.registry;

import com.t2pellet.haybale.common.capability.api.Capability;
import com.t2pellet.haybale.common.capability.api.ICapabilityHaver;
import com.t2pellet.haybale.common.capability.registry.CapabilityRegistrar;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import net.minecraft.class_1297;

public interface IModCapabilities {

    @Retention(RetentionPolicy.RUNTIME)
    @Target(ElementType.FIELD)
    @interface ICapability {
        Class<? extends Capability> value();
    }

    class HaybaleCapability<T extends Capability> {
        CapabilityRegistrar.CapabilityFactory<T> supplier;

        public HaybaleCapability(CapabilityRegistrar.CapabilityFactory<T> supplier) {
            this.supplier = supplier;
        }

        public <E extends class_1297 & ICapabilityHaver> T get(E entity) {
            return supplier.get(entity);
        }
    }

}
