//? if fabric {
package com.t2pellet.haybale.fabric.registry;

import com.t2pellet.haybale.Services;
import com.t2pellet.haybale.common.network.api.Packet;
import com.t2pellet.haybale.common.utils.VersionHelper;
import com.t2pellet.haybale.registry.ICommonRegistry;
import com.t2pellet.haybale.common.registry.api.EntityEntryType;
import com.t2pellet.haybale.common.registry.api.ItemEntryType;
import com.t2pellet.haybale.common.registry.api.ParticleEntryType;
import com.t2pellet.haybale.common.registry.api.SoundEntryType;
import com.t2pellet.haybale.fabric.network.PacketHandler;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.fabricmc.fabric.api.particle.v1.FabricParticleTypes;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1311;
import net.minecraft.class_1792;
import net.minecraft.class_2378;
import net.minecraft.class_2400;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_7923;
import java.util.function.Supplier;

public class CommonRegistry implements ICommonRegistry {


    @Override
    public Supplier<class_2400> register(String modid, ParticleEntryType particleEntryType) {
        class_2960 id = VersionHelper.getResourceLocation(modid, particleEntryType.getName());
        class_2400 type = class_2378.method_10230(
                //? if >= 1.19.4 {
                class_7923.field_41180,
                //?} else
                /*Registry.PARTICLE_TYPE,*/
                id,
                FabricParticleTypes.simple()
        );
        return () -> type;
    }

    @Override
    public <T extends class_1309> Supplier<class_1299<T>> register(String modid, EntityEntryType<T> entityEntryType) {
        //? if >= 1.21.2 {
        /*ResourceLocation id = VersionHelper.getResourceLocation(modid, entityEntryType.getName());
        ResourceKey<EntityType<?>> key = ResourceKey.create(Registries.ENTITY_TYPE, id);
        *///?}
        class_1299<T> type = class_2378.method_10230(
                //? if >= 1.19.4 {
                class_7923.field_41177,
                //?} else
                /*Registry.ENTITY_TYPE,*/
                VersionHelper.getResourceLocation(modid, entityEntryType.getName()),
                class_1299.class_1300.method_5903(entityEntryType.getFactory(), class_1311.field_6294)
                        .method_27299(48).method_27300(3).method_17687(entityEntryType.getWidth(), entityEntryType.getHeight())
                        //? if < 1.21.2 {
                        .method_5905(entityEntryType.getName()));
                        //?} else
                        /*.build(key));*/
        FabricDefaultAttributeRegistry.register(
                type,
                //? if >= 1.19.4 {
                entityEntryType.buildAttributes().method_26866()
                //?} else
                /*entityEntryType.buildAttributes()*/
        );
        return () -> type;
    }

    @Override
    public Supplier<class_3414> register(String modid, SoundEntryType soundEntryType) {
        class_2960 location = VersionHelper.getResourceLocation(modid, soundEntryType.getName());
        //? if >= 1.19.4 {
        class_3414 soundEvent = class_3414.method_47908(location);
        //?} else
        /*SoundEvent soundEvent = new SoundEvent(location);*/
        class_2378.method_10230(
                //? if >= 1.19.4 {
                class_7923.field_41172,
                //?} else
                /*Registry.SOUND_EVENT,*/
                location,
                soundEvent
        );
        return () -> soundEvent;
    }

    @Override
    public Supplier<class_1792> register(String modid, ItemEntryType itemEntryType) {
        class_1792 item = class_2378.method_10230(
                //? if >= 1.19.4 {
                class_7923.field_41178,
                //?} else
                /*Registry.ITEM,*/
                VersionHelper.getResourceLocation(modid, itemEntryType.getName()), new class_1792(itemEntryType.getProperties())
        );
        return () -> item;
    }

    @Override
    public void registerServerPacket(String modid, String name, Class<? extends Packet> packetClass) {
        PacketHandler packetHandler = (PacketHandler) Services.PACKET_HANDLER;
        packetHandler.registerServerPacket(modid, name, packetClass);
    }

    @Override
    public void registerClientPacket(String modid, String name, Class<? extends Packet> packetClass) {
        PacketHandler packetHandler = (PacketHandler) Services.PACKET_HANDLER;
        packetHandler.registerClientPacket(modid, name, packetClass);
    }
}
//?}