/*
 * Decompiled with CFR 0.152.
 */
package com.t2pellet.haybale.common.capability.api;

import com.t2pellet.haybale.Haybale;
import com.t2pellet.haybale.common.capability.api.Capability;
import com.t2pellet.haybale.common.capability.api.CapabilityManager;
import com.t2pellet.haybale.common.capability.registry.CapabilityRegistrar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;

class CapabilityManagerImpl<E extends Entity>
implements CapabilityManager {
    private final Map<Class<? extends Capability>, Capability> map = new HashMap<Class<? extends Capability>, Capability>();
    private final E entity;

    CapabilityManagerImpl(E entity) {
        this.entity = entity;
    }

    @Override
    public <T extends Capability> T addCapability(Class<T> capabilityClass) {
        this.instantiateCapability(capabilityClass);
        return (T)this.map.get(capabilityClass);
    }

    @Override
    public <T extends Capability> T getCapability(Class<T> capabilityClass) {
        return (T)this.map.get(capabilityClass);
    }

    public List<Capability> getCapabilities() {
        return this.map.values().stream().toList();
    }

    @Override
    public <T extends Capability> void setCapability(Class<T> capabilityClass, T capability) {
        this.map.put(capabilityClass, capability);
    }

    @Override
    public Tag writeTag() {
        ListTag tag = new ListTag();
        this.map.forEach((aClass, capability) -> {
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.putString("className", aClass.getName());
            compoundTag.put("capability", capability.writeTag());
            tag.add((Object)compoundTag);
        });
        return tag;
    }

    @Override
    public void readTag(Tag tag) {
        ListTag listTag = (ListTag)tag;
        listTag.forEach(tagInList -> {
            CompoundTag compoundTag = (CompoundTag)tagInList;
            try {
                String className = (String)compoundTag.getString("className").orElseThrow();
                Class<?> aClass = Class.forName(className);
                if (!this.map.containsKey(aClass)) {
                    this.instantiateCapability(aClass);
                }
                this.map.get(aClass).readTag(compoundTag.get("capability"));
            }
            catch (ClassNotFoundException e) {
                Haybale.LOG.error("Failed to instantiate capability from NBT", (Throwable)e);
            }
        });
    }

    private <T extends Capability> void instantiateCapability(Class<T> aClass) {
        this.map.put(aClass, (Capability)CapabilityRegistrar.INSTANCE.get(aClass, this.entity).orElseThrow(() -> new InstantiationError("Failed to instantiate capability for class: " + aClass.getSimpleName())));
    }
}

