/*
 * Decompiled with CFR 0.152.
 */
package com.t2pellet.haybale.mixin;

import com.google.gson.JsonElement;
import com.t2pellet.haybale.common.capability.api.ICapabilityHaver;
import com.t2pellet.haybale.common.utils.compound.JsonToNbt;
import com.t2pellet.haybale.common.utils.compound.NbtToJson;
import java.util.Optional;
import net.minecraft.nbt.Tag;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public class EntityMixin {
    @Inject(method={"readAdditionalSaveData(Lnet/minecraft/world/level/storage/ValueInput;)V"}, at={@At(value="TAIL")})
    public void readFromTag(ValueInput valueInput, CallbackInfo ci) {
        Entity e = (Entity)this;
        if (e instanceof ICapabilityHaver) {
            ICapabilityHaver capabilityHaver = (ICapabilityHaver)e;
            Optional json = valueInput.read("capabilityData", ExtraCodecs.JSON);
            if (json.isPresent()) {
                Tag tag = JsonToNbt.toNbt((JsonElement)json.get());
                capabilityHaver.getCapabilityManager().readTag(tag);
            }
        }
    }

    @Inject(method={"addAdditionalSaveData(Lnet/minecraft/world/level/storage/ValueOutput;)V"}, at={@At(value="TAIL")})
    public void writeToTag(ValueOutput valueOutput, CallbackInfo ci) {
        Entity e = (Entity)this;
        if (e instanceof ICapabilityHaver) {
            ICapabilityHaver capabilityHaver = (ICapabilityHaver)e;
            Tag capabilityTag = capabilityHaver.getCapabilityManager().writeTag();
            JsonElement json = NbtToJson.toJson(capabilityTag);
            valueOutput.store("capabilityData", ExtraCodecs.JSON, (Object)json);
        }
    }
}

