/*
 * Decompiled with CFR 0.152.
 */
package com.t2pellet.haybale.neoforge;

import com.t2pellet.haybale.HaybaleMod;
import com.t2pellet.haybale.Services;
import com.t2pellet.haybale.client.HaybaleModClient;
import com.t2pellet.haybale.client.compat.ConfigMenu;
import com.t2pellet.haybale.common.ClientRegistrar;
import com.t2pellet.haybale.common.CommonRegistrar;
import com.t2pellet.haybale.common.config.ConfigRegistrar;
import com.t2pellet.haybale.neoforge.HaybaleNeoforge;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.registries.DeferredRegister;

public abstract class HaybaleNeoforgeMod {
    public final IEventBus modBus;
    private final String modid;
    private final HaybaleMod commonMod;
    private final HaybaleModClient clientMod;
    public final DeferredRegister<EntityType<?>> ENTITIES;
    public final DeferredRegister<ParticleType<?>> PARTICLES;
    public final DeferredRegister<SoundEvent> SOUNDS;
    public final DeferredRegister<Item> ITEMS;

    public HaybaleNeoforgeMod(IEventBus modBus) {
        this.initialSetup();
        HaybaleMod.IMod modAnnotation = this.getClass().getAnnotation(HaybaleMod.IMod.class);
        this.modBus = modBus;
        this.commonMod = this.getCommonMod();
        this.clientMod = this.getClientMod();
        this.modid = modAnnotation.value();
        HaybaleNeoforge.getInstance().register(this.modid, this);
        this.ENTITIES = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)this.modid);
        this.ITEMS = DeferredRegister.create((ResourceKey)Registries.ITEM, (String)this.modid);
        this.PARTICLES = DeferredRegister.create((ResourceKey)Registries.PARTICLE_TYPE, (String)this.modid);
        this.SOUNDS = DeferredRegister.create((ResourceKey)Registries.SOUND_EVENT, (String)this.modid);
        this.onCommonSetup();
        if (FMLEnvironment.dist == Dist.CLIENT) {
            this.onClientSetup();
        }
        this.ENTITIES.register(modBus);
        this.ITEMS.register(modBus);
        this.PARTICLES.register(modBus);
        this.SOUNDS.register(modBus);
        this.registerEvents(modBus);
    }

    protected void initialSetup() {
    }

    protected abstract HaybaleMod getCommonMod();

    protected abstract HaybaleModClient getClientMod();

    protected void registerEvents(IEventBus modBus) {
    }

    private void onCommonSetup() {
        if (this.commonMod != null) {
            CommonRegistrar.INSTANCE.registerFromClass(this.modid, this.commonMod.particles());
            CommonRegistrar.INSTANCE.registerFromClass(this.modid, this.commonMod.entities());
            CommonRegistrar.INSTANCE.registerFromClass(this.modid, this.commonMod.items());
            CommonRegistrar.INSTANCE.registerFromClass(this.modid, this.commonMod.sounds());
            CommonRegistrar.INSTANCE.registerPackets(this.modid, this.commonMod.packets());
            CommonRegistrar.INSTANCE.registerCapabilities(this.modid, this.commonMod.capabilities());
            ConfigRegistrar.INSTANCE.register(this.modid, this.commonMod::config);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void onClientSetup() {
        if (this.clientMod != null) {
            ClientRegistrar.INSTANCE.registerFromClass(this.modid, this.clientMod.entityModels());
            ClientRegistrar.INSTANCE.registerFromClass(this.modid, this.clientMod.entityRenderers());
            ClientRegistrar.INSTANCE.registerFromClass(this.modid, this.clientMod.particleFactories());
        }
        if (Services.PLATFORM.isModLoaded("cloth_config")) {
            ConfigMenu configMenu = new ConfigMenu(this.modid);
            ModLoadingContext.get().registerExtensionPoint(IConfigScreenFactory.class, () -> (minecraft, screen) -> configMenu.buildConfigScreen());
        }
    }
}

