/*
 * Decompiled with CFR 0.152.
 */
package com.t2pellet.haybale.forge;

import com.t2pellet.haybale.HaybaleMod;
import com.t2pellet.haybale.Services;
import com.t2pellet.haybale.client.HaybaleModClient;
import com.t2pellet.haybale.client.compat.ConfigMenu;
import com.t2pellet.haybale.common.ClientRegistrar;
import com.t2pellet.haybale.common.CommonRegistrar;
import com.t2pellet.haybale.common.config.ConfigRegistrar;
import com.t2pellet.haybale.forge.HaybaleForge;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ConfigGuiHandler;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public abstract class HaybaleForgeMod {
    private final String modid;
    private final HaybaleMod commonMod;
    private final HaybaleModClient clientMod;
    public final DeferredRegister<EntityType<?>> ENTITIES;
    public final DeferredRegister<ParticleType<?>> PARTICLES;
    public final DeferredRegister<SoundEvent> SOUNDS;
    public final DeferredRegister<Item> ITEMS;

    public HaybaleForgeMod() {
        this.initialSetup();
        HaybaleMod.IMod modAnnotation = this.getClass().getAnnotation(HaybaleMod.IMod.class);
        this.commonMod = this.getCommonMod();
        this.clientMod = this.getClientMod();
        this.modid = modAnnotation.value();
        HaybaleForge.getInstance().register(this.modid, this);
        this.ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITIES, (String)this.modid);
        this.ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)this.modid);
        this.PARTICLES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.PARTICLE_TYPES, (String)this.modid);
        this.SOUNDS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)this.modid);
        this.onCommonSetup();
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> this::onClientSetup);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        this.ENTITIES.register(bus);
        this.ITEMS.register(bus);
        this.PARTICLES.register(bus);
        this.SOUNDS.register(bus);
        this.registerEvents();
    }

    protected void initialSetup() {
    }

    protected abstract HaybaleMod getCommonMod();

    protected abstract HaybaleModClient getClientMod();

    protected void registerEvents() {
    }

    private void onCommonSetup() {
        if (this.commonMod != null) {
            CommonRegistrar.INSTANCE.registerFromClass(this.modid, this.commonMod.particles());
            CommonRegistrar.INSTANCE.registerFromClass(this.modid, this.commonMod.entities());
            CommonRegistrar.INSTANCE.registerFromClass(this.modid, this.commonMod.items());
            CommonRegistrar.INSTANCE.registerFromClass(this.modid, this.commonMod.sounds());
            CommonRegistrar.INSTANCE.registerPackets(this.modid, this.commonMod.packets());
            CommonRegistrar.INSTANCE.registerCapabilities(this.modid, this.commonMod.capabilities());
            ConfigRegistrar.INSTANCE.register(this.modid, this.commonMod::config);
        }
    }

    private void onClientSetup() {
        if (this.clientMod != null) {
            ClientRegistrar.INSTANCE.registerFromClass(this.modid, this.clientMod.entityModels());
            ClientRegistrar.INSTANCE.registerFromClass(this.modid, this.clientMod.entityRenderers());
            ClientRegistrar.INSTANCE.registerFromClass(this.modid, this.clientMod.particleFactories());
        }
        if (Services.PLATFORM.isModLoaded("cloth_config")) {
            ConfigMenu configMenu = new ConfigMenu(this.modid);
            ModLoadingContext.get().registerExtensionPoint(ConfigGuiHandler.ConfigGuiFactory.class, () -> new ConfigGuiHandler.ConfigGuiFactory((minecraft, screen) -> configMenu.buildConfigScreen()));
        }
    }
}

