/*
 * Decompiled with CFR 0.152.
 */
package com.t2pellet.haybale.client.compat;

import com.t2pellet.haybale.Haybale;
import com.t2pellet.haybale.common.config.ConfigRegistrar;
import com.t2pellet.haybale.common.config.api.Config;
import com.t2pellet.haybale.common.config.api.property.BoolProperty;
import com.t2pellet.haybale.common.config.api.property.ConfigProperty;
import com.t2pellet.haybale.common.config.api.property.FloatProperty;
import com.t2pellet.haybale.common.config.api.property.IntProperty;
import com.t2pellet.haybale.common.config.api.property.ListProperty;
import com.t2pellet.haybale.common.config.api.property.PropertyType;
import com.t2pellet.haybale.common.config.api.property.StringProperty;
import com.t2pellet.haybale.common.utils.VersionHelper;
import java.io.IOException;
import java.lang.reflect.Field;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.gui.entries.TooltipListEntry;
import me.shedaniel.clothconfig2.impl.builders.AbstractFieldBuilder;
import me.shedaniel.clothconfig2.impl.builders.FieldBuilder;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import net.minecraft.class_5348;

public class ConfigMenu {
    final String modid;
    final Config config;

    public ConfigMenu(String modid) {
        this.modid = modid;
        this.config = ConfigRegistrar.INSTANCE.get(this.modid);
    }

    public class_437 buildConfigScreen() {
        try {
            return this.configBuilder().build();
        }
        catch (IllegalAccessException ex) {
            Haybale.LOG.error("Failed to build config screen for mod: " + this.modid);
            Haybale.LOG.error((Object)ex);
            return null;
        }
    }

    private ConfigBuilder configBuilder() throws IllegalAccessException {
        class_2561 component = VersionHelper.translatableComponent("title." + this.modid + ".config");
        ConfigBuilder builder = ConfigBuilder.create().setTitle(component);
        for (Class<?> clazz : this.config.getClass().getDeclaredClasses()) {
            Config.Section section = clazz.getAnnotation(Config.Section.class);
            if (section == null) continue;
            this.addSection(builder, clazz, section);
        }
        return builder;
    }

    private void addSection(ConfigBuilder configBuilder, Class<?> clazz, Config.Section section) throws IllegalAccessException {
        class_2561 component = VersionHelper.literalComponent(section.name());
        ConfigCategory category = configBuilder.getOrCreateCategory(component);
        category.setDescription(new class_5348[]{class_5348.method_29430((String)section.description())});
        ConfigEntryBuilder builder = configBuilder.entryBuilder();
        for (Field field : clazz.getDeclaredFields()) {
            Class<?> type = field.getType();
            field.setAccessible(true);
            if (StringProperty.class.isAssignableFrom(type)) {
                category.addEntry(this.addField((arg_0, arg_1) -> ((ConfigEntryBuilder)builder).startStrField(arg_0, arg_1), field));
                continue;
            }
            if (IntProperty.class.isAssignableFrom(type)) {
                category.addEntry(this.addField((arg_0, arg_1) -> ((ConfigEntryBuilder)builder).startIntField(arg_0, arg_1), field));
                continue;
            }
            if (BoolProperty.class.isAssignableFrom(type)) {
                category.addEntry(this.addField((arg_0, arg_1) -> ((ConfigEntryBuilder)builder).startBooleanToggle(arg_0, arg_1), field));
                continue;
            }
            if (FloatProperty.class.isAssignableFrom(type)) {
                category.addEntry(this.addField((arg_0, arg_1) -> ((ConfigEntryBuilder)builder).startFloatField(arg_0, arg_1), field));
                continue;
            }
            if (!ListProperty.class.isAssignableFrom(type)) continue;
            ListProperty property = (ListProperty)field.get(null);
            if (property.getType() == PropertyType.INT) {
                category.addEntry(this.addField((arg_0, arg_1) -> ((ConfigEntryBuilder)builder).startIntList(arg_0, arg_1), field));
                continue;
            }
            if (property.getType() == PropertyType.FLOAT) {
                category.addEntry(this.addField((arg_0, arg_1) -> ((ConfigEntryBuilder)builder).startFloatList(arg_0, arg_1), field));
                continue;
            }
            category.addEntry(this.addField((arg_0, arg_1) -> ((ConfigEntryBuilder)builder).startStrList(arg_0, arg_1), field));
        }
    }

    private <T, R extends TooltipListEntry<T>, S extends FieldBuilder<T, R, S>> R addField(IBuilderFactory<T, R, S> builderFactory, Field field) throws IllegalAccessException {
        ConfigProperty property = (ConfigProperty)field.get(null);
        Object value = property.get();
        Config.Entry comment = field.getAnnotation(Config.Entry.class);
        class_2561 component = VersionHelper.literalComponent(field.getName());
        FieldBuilder<T, R, S> fieldBuilder = builderFactory.create(component, value);
        if (fieldBuilder instanceof AbstractFieldBuilder) {
            AbstractFieldBuilder betterFieldBuilder = (AbstractFieldBuilder)fieldBuilder;
            betterFieldBuilder.setDefaultValue(property.getDefault());
            betterFieldBuilder.setSaveConsumer(s -> this.updateProperty(property, s));
            class_2561 tooltip = VersionHelper.literalComponent(comment.comment());
            if (comment != null) {
                betterFieldBuilder.setTooltip(new class_2561[]{tooltip});
            }
        }
        return (R)((TooltipListEntry)fieldBuilder.build());
    }

    private <T> void updateProperty(ConfigProperty<T> property, T value) {
        try {
            property.set(value);
            this.config.save();
        }
        catch (IOException | IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    static interface IBuilderFactory<T, R extends TooltipListEntry<T>, S extends FieldBuilder<T, R, S>> {
        public FieldBuilder<T, R, S> create(class_2561 var1, T var2);
    }
}

