/*
 * Decompiled with CFR 0.152.
 */
package com.t2pellet.haybale.common;

import com.t2pellet.haybale.Haybale;
import com.t2pellet.haybale.common.BaseRegistrar;
import com.t2pellet.haybale.common.capability.api.Capability;
import com.t2pellet.haybale.common.capability.api.registry.IModCapabilities;
import com.t2pellet.haybale.common.capability.registry.CapabilityRegistrar;
import com.t2pellet.haybale.common.network.api.registry.IModPackets;
import com.t2pellet.haybale.common.registry.api.EntityEntryType;
import com.t2pellet.haybale.common.registry.api.EntryType;
import com.t2pellet.haybale.common.registry.api.ItemEntryType;
import com.t2pellet.haybale.common.registry.api.ParticleEntryType;
import com.t2pellet.haybale.common.registry.api.SoundEntryType;
import com.t2pellet.haybale.registry.ICommonRegistry;
import java.lang.reflect.Field;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_2400;
import net.minecraft.class_3414;

public class CommonRegistrar
extends BaseRegistrar {
    public static final CommonRegistrar INSTANCE = new CommonRegistrar();
    private static final ICommonRegistry COMMON_REGISTRY = ServiceLoader.load(ICommonRegistry.class).findFirst().orElseThrow(() -> new NullPointerException("Failed to load common registry service"));

    private CommonRegistrar() {
    }

    @Override
    protected boolean checkIsValid(Class<?> type) {
        return type.isAssignableFrom(class_2400.class) || type.isAssignableFrom(class_1299.class) || type.isAssignableFrom(class_3414.class) || type.isAssignableFrom(class_1792.class);
    }

    @Override
    protected void doGenericRegistration(String modid, Class<?> registryType, Field declaredField) throws IllegalAccessException {
        EntryType entryType = (EntryType)declaredField.get(null);
        if (registryType.isAssignableFrom(entryType.type)) {
            Supplier<Object> result = entryType instanceof ParticleEntryType ? COMMON_REGISTRY.register(modid, (ParticleEntryType)entryType) : (entryType instanceof EntityEntryType ? COMMON_REGISTRY.register(modid, (EntityEntryType)entryType) : (entryType instanceof SoundEntryType ? COMMON_REGISTRY.register(modid, (SoundEntryType)entryType) : (entryType instanceof ItemEntryType ? COMMON_REGISTRY.register(modid, (ItemEntryType)entryType) : null)));
            this.setField("supplier", entryType, result);
        }
    }

    public void registerPackets(String modid, IModPackets packets) {
        if (packets == null) {
            return;
        }
        Haybale.LOG.debug("Registering packets for modid: " + modid);
        for (Field field : packets.getClass().getDeclaredFields()) {
            IModPackets.IPacket packetInfo = field.getAnnotation(IModPackets.IPacket.class);
            if (packetInfo == null || !field.getType().equals(IModPackets.HaybalePacket.class)) continue;
            try {
                IModPackets.HaybalePacket packet = (IModPackets.HaybalePacket)field.get(null);
                if (packetInfo.client()) {
                    COMMON_REGISTRY.registerClientPacket(modid, packetInfo.name(), packet.getPacketClass());
                    continue;
                }
                COMMON_REGISTRY.registerServerPacket(modid, packetInfo.name(), packet.getPacketClass());
            }
            catch (Exception e) {
                Haybale.LOG.error("Failed to register packets for " + modid);
                Haybale.LOG.error((Object)e);
            }
        }
    }

    public void registerCapabilities(String modid, IModCapabilities capabilities) {
        if (capabilities == null) {
            return;
        }
        Haybale.LOG.debug("Registering capabilities for modid: " + modid);
        for (Field field : capabilities.getClass().getDeclaredFields()) {
            IModCapabilities.ICapability capabilityInfo = field.getAnnotation(IModCapabilities.ICapability.class);
            if (capabilityInfo == null || !field.getType().equals(IModCapabilities.HaybaleCapability.class)) continue;
            try {
                IModCapabilities.HaybaleCapability capability = (IModCapabilities.HaybaleCapability)field.get(null);
                CommonRegistrar.registerCapability(capabilityInfo.value(), x$0 -> capability.get(x$0));
            }
            catch (Exception e) {
                Haybale.LOG.error("Failed to register capabilities for " + modid);
                Haybale.LOG.error((Object)e);
            }
        }
    }

    private static <T extends Capability> void registerCapability(Class<? extends Capability> clazz, CapabilityRegistrar.CapabilityFactory<T> supplier) {
        CapabilityRegistrar.INSTANCE.register(clazz, supplier);
    }
}

