package com.t2pellet.haybale.common.capability.registry;

import com.t2pellet.haybale.common.capability.api.Capability;
import com.t2pellet.haybale.common.capability.api.ICapabilityHaver;
import java.util.Optional;
import net.minecraft.class_1297;

public interface CapabilityRegistrar {

    @FunctionalInterface
    interface CapabilityFactory<T extends Capability> {
        <E extends class_1297 & ICapabilityHaver> T get(E entity);
    }

    /**
     * The capability handler instance. Use this to register and instantiate your capabilities
     */
    CapabilityRegistrar INSTANCE = new CapabilityRegistrarImpl();

    /**
     * Registers the given capability.
     *
     * @param cap     : the capability class
     * @param factory : the capability factory
     * @param <T>     the capability parameter
     */
    <T extends Capability> void register(Class<T> cap, CapabilityFactory<T> factory);

    /**
     * Instantiates the given capability, if registered
     *
     * @param cap the capability class
     * @param <T> the capability parameter
     * @return an optional for the instance of the capability. Optional is empty if the capability is not registered
     */
    <T extends Capability, E extends class_1297 & ICapabilityHaver> Optional<T> get(Class<T> cap, E entity);

}
