package com.t2pellet.haybale.common.utils.compound;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import net.minecraft.class_2481;
import net.minecraft.class_2487;
import net.minecraft.class_2491;
import net.minecraft.class_2499;
import net.minecraft.class_2514;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.nbt.*;

import java.util.Map;

public class NbtToJson {

    public static JsonElement toJson(class_2520 nbtElement) {
        return toJson(nbtElement, ConversionMode.RAW);
    }

    /**
     * Converts an NBT tag to a JSON element.
     *
     * @param nbtElement NBT tag to convert.
     * @param mode The conversion mode.
     * @return The JSON element equivalent. (imperfect in certain cases)
     */
    public static JsonElement toJson(class_2520 nbtElement, ConversionMode mode) {

        // Numbers
        if (nbtElement instanceof class_2514 nbtNumber) {
            switch (mode) {
                case JSON: {
                    if (nbtNumber instanceof class_2481 nbtByte) {
                        //? if >= 1.21.5 {
                        byte value = nbtByte.method_68600().orElseThrow();
                        //?} else
                        /*byte value = nbtByte.getAsByte();*/
                        switch (value) {
                            case 0: return new JsonPrimitive(false);
                            case 1: return new JsonPrimitive(true);
                            default: // Continue
                        }
                    }
                    // Else, continue
                }
                case RAW: {
                    //? if >= 1.21.5 {
                    Number number = nbtNumber.method_68599().orElseThrow();
                    //?} else
                    /*Number number = nbtNumber.getAsNumber();*/
                    return new JsonPrimitive(number);
                }
            }
        } else if (nbtElement instanceof class_2519 nbtString) {
            // String
            //? if >= 1.21.5 {
            String string = nbtString.method_68658().orElseThrow();
            //?} else
            /*String string = nbtString.getAsString();*/
            return new JsonPrimitive(string);
        } else if (nbtElement instanceof class_2499 nbtList) {
            // Lists
            JsonArray jsonArray = new JsonArray();
            for (class_2520 nbtBase : nbtList) {
                jsonArray.add(toJson(nbtBase, mode));
            }

            return jsonArray;

        } else if (nbtElement instanceof class_2487 nbtCompound) {
            // Compound tag
            JsonObject jsonObject = new JsonObject();

            //? if >= 1.21.5 {
            for (Map.Entry<String, class_2520> nbtEntry : nbtCompound.method_59874()) {
                jsonObject.add(nbtEntry.getKey(), toJson(nbtEntry.getValue(), mode));
            }
            //?} else {
            /*for (String key : nbtCompound.getAllKeys()) {
                Tag entry = nbtCompound.get(key);
                jsonObject.add(key, toJson(entry, mode));
            }
            *///?}

            return jsonObject;

            // Nbt termination tag. Should not be encountered.
        } else if (nbtElement instanceof class_2491) {
            throw new AssertionError();
        }

        // Impossible unless a new NBT class is made.
        throw new UnsupportedOperationException();
    }

    /**
     * The NBT to JSON conversion mode.
     */
    public enum ConversionMode {

        /**
         * The NBT will be converted to JSON 'as is'.
         */
        RAW,
        /**
         * The NBT will be converted to JSOn with the assumption that it
         * was previously JSON, and therefore certain assumptions and
         * conversions will be made.
         *
         * Conversions:
         *
         * 0b -> false
         * 1b -> true
         */
        JSON
    }
}
