//? if fabric {
package com.t2pellet.haybale.fabric.network;

import com.t2pellet.haybale.Haybale;
import com.t2pellet.haybale.Services;
import com.t2pellet.haybale.common.utils.VersionHelper;
import com.t2pellet.haybale.services.IPacketHandler;
import com.t2pellet.haybale.common.network.api.Packet;
import io.netty.buffer.Unpooled;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
//? if >= 1.20.5 {
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
//?}
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;

public class PacketHandler implements IPacketHandler {

    private final Map<Class<? extends Packet>, class_2960> idMap;

    //? if >= 1.20.5 {
    private static <T extends Packet> class_9139<class_2540, FabricPacket<T>> getCodec(Class<T> packetClass, class_2960 id) {
        return class_9139.method_56437(
                (packetByteBuf, fabricPacket) -> {
                    // Encode
                    fabricPacket.encode(packetByteBuf);
                },
                (packetByteBuf) -> {
                    // Decode
                    try {
                        T packet = packetClass.getDeclaredConstructor(class_2540.class).newInstance(packetByteBuf);
                        return new FabricPacket<>(packet, id);
                    } catch (NoSuchMethodException | InstantiationException | IllegalAccessException |
                            InvocationTargetException ex) {
                        Haybale.LOG.error("Error: Failed to instantiate packet - " + id);
                    }
                    return null;
                }
        );
    }

    private static class FabricPacket<T extends Packet> implements class_8710 {

        private final T packet;
        private final class_9154<FabricPacket<T>> type;

        public FabricPacket(T packet, class_2960 id) {
            this.packet = packet;
            this.type = new class_8710.class_9154<>(id);
        }

        @Override
        public @NotNull class_9154<FabricPacket<T>> method_56479() {
            return this.type;
        }

        public void encode(class_2540 packetByteBuf) {
            this.packet.encode(packetByteBuf);
        }

        public Runnable executor() {
            return this.packet.getExecutor();
        }
    }
    //?}

    public PacketHandler() {
        idMap = new HashMap<>();
    }

    public <T extends Packet> void registerServerPacket(String modid, String name, Class<T> packetClass) {
        class_2960 loc = VersionHelper.getResourceLocation(modid, name);
        idMap.put(packetClass, loc);
        //? if < 1.20.5 {
        /*ServerPlayNetworking.registerGlobalReceiver(loc, (minecraftServer, serverPlayer, serverPlayNetworkHandler, packetByteBuf, packetSender) -> {
            try {
                T packet = packetClass.getDeclaredConstructor(FriendlyByteBuf.class).newInstance(packetByteBuf);
                Services.SIDE.scheduleServer(packet.getExecutor());
            } catch (NoSuchMethodException | InstantiationException | IllegalAccessException |
                    InvocationTargetException ex) {
                Haybale.LOG.error("Error: Failed to instantiate packet - " + loc);
            }
        });
        *///?} else {
        class_8710.class_9154<FabricPacket<T>> type = new class_8710.class_9154<>(loc);
        PayloadTypeRegistry.playC2S().register(type, PacketHandler.getCodec(packetClass, loc));
        ServerPlayNetworking.registerGlobalReceiver(type, (payload, context) -> {
            Services.SIDE.scheduleServer(payload.executor());
        });
        //?}
    }

    public <T extends Packet> void registerClientPacket(String modid, String name, Class<T> packetClass) {
        class_2960 loc = VersionHelper.getResourceLocation(modid, name);
        idMap.put(packetClass, loc);
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            _registerClientPacket(loc, packetClass);
        }
    }

    @Environment(EnvType.CLIENT)
    private <T extends Packet> void _registerClientPacket(class_2960 id, Class<T> packetClass) {
        //? if < 1.20.5 {
        /*ClientPlayNetworking.registerGlobalReceiver(id, (client, handler, buf, responseSender) -> {
            try {
                T packet = packetClass.getDeclaredConstructor(FriendlyByteBuf.class).newInstance(buf);
                Services.SIDE.scheduleClient(packet.getExecutor());
            } catch (NoSuchMethodException | InstantiationException | IllegalAccessException |
                     InvocationTargetException ex) {
                Haybale.LOG.error("Error: Failed to instantiate packet - " + id);
            }
        });
        *///?} else {
        class_8710.class_9154<FabricPacket<T>> type = new class_8710.class_9154<>(id);
        PayloadTypeRegistry.playS2C().register(type, PacketHandler.getCodec(packetClass, id));
        ClientPlayNetworking.registerGlobalReceiver(type, (payload, context) -> {
            Services.SIDE.scheduleClient(payload.executor());
        });
        //?}
    }

    @Override
    public <T extends Packet> void sendToServer(T packet) {
        class_2540 data = new class_2540(Unpooled.buffer());
        packet.encode(data);
        //? if < 1.20.5 {
        /*ClientPlayNetworking.send(idMap.get(packet.getClass()), data);
        *///?} else {
        class_2960 id = idMap.get(packet.getClass());
        FabricPacket<T> fabricPacket = new FabricPacket<>(packet, id);
        ClientPlayNetworking.send(fabricPacket);
        //?}
    }

    @Override
    public <T extends Packet> void sendTo(T packet, class_3222 player) {
        class_2540 data = new class_2540(Unpooled.buffer());
        packet.encode(data);
        //? if < 1.20.5 {
        /*ServerPlayNetworking.send(player, idMap.get(packet.getClass()), data);
        *///?} else {
        class_2960 id = idMap.get(packet.getClass());
        FabricPacket<T> fabricPacket = new FabricPacket<>(packet, id);
        ServerPlayNetworking.send(player, fabricPacket);
        //?}
    }

    @Override
    public <T extends Packet> void sendTo(T packet, class_3222... players) {
        class_2540 data = new class_2540(Unpooled.buffer());
        class_2960 id = idMap.get(packet.getClass());
        //? if < 1.20.5 {
        /*packet.encode(data);
        for (ServerPlayer player : players) ServerPlayNetworking.send(player, id, data);
        *///?} else {
        FabricPacket<T> fabricPacket = new FabricPacket<>(packet, id);
        for (class_3222 player : players) ServerPlayNetworking.send(player, fabricPacket);
        //?}
    }

    @Override
    public <T extends Packet> void sendInRange(T packet, class_1297 e, float range) {
        class_238 box = new class_238(e.method_24515()).method_1014(range);
        class_1937 level = VersionHelper.getLevel(e);
        sendInArea(packet, level, box);
    }

    @Override
    public <T extends Packet> void sendInArea(T packet, class_1937 world, class_238 area) {
        class_3222[] players = ((class_3218) world).method_18456().stream().filter((p) -> area.method_1006(p.method_19538())).toArray(class_3222[]::new);
        sendTo(packet, players);
    }

}
//?}