package com.t2pellet.haybale.mixin;

import com.t2pellet.haybale.common.capability.api.AbstractCapability;
import com.t2pellet.haybale.common.capability.api.ICapabilityHaver;
import net.minecraft.class_1297;
import net.minecraft.class_3222;
import net.minecraft.class_3231;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_3231.class)
public class ServerEntityMixin {

    @Shadow
    @Final
    private class_1297 entity;

    @Inject(method = "addPairing", at = @At("TAIL"))
    public void addPairing(class_3222 player, CallbackInfo ci) {
        if (entity instanceof ICapabilityHaver capabilityHaver) {
            capabilityHaver.getCapabilityManager().getCapabilities().forEach(c -> {
                if (c instanceof AbstractCapability<?> abstractCapability) {
                    abstractCapability.synchronizeTo(player);
                }
            });
        }
    }

}
