package com.t2pellet.haybale.common.capability.api;

import com.t2pellet.haybale.Services;
import com.t2pellet.haybale.common.network.capability.CapabilityPacket;
import com.t2pellet.haybale.common.utils.VersionHelper;
import net.minecraft.class_1297;
import net.minecraft.class_3222;

public abstract class AbstractCapability<E extends class_1297 & ICapabilityHaver> implements Capability {

    protected E entity;

    protected AbstractCapability(E entity) {
        this.entity = entity;
    }

    public void synchronize() {
        class_1297 entity = this.entity;
        if (!VersionHelper.getLevel(entity).field_9236) {
            CapabilityPacket<E> packet = new CapabilityPacket<>(this.entity, getClass());
            Services.PACKET_HANDLER.sendInRange(packet, this.entity, 128);
        }
    }

    public void synchronizeTo(class_3222 player) {
        if (!VersionHelper.getLevel(entity).field_9236) {
            CapabilityPacket<E> packet = new CapabilityPacket<>(entity, getClass());
            Services.PACKET_HANDLER.sendTo(packet, player);
        }
    }

}
