package com.t2pellet.haybale.common.capability.api;

import com.t2pellet.haybale.Haybale;
import com.t2pellet.haybale.common.capability.registry.CapabilityRegistrar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;

class CapabilityManagerImpl<E extends class_1297 & ICapabilityHaver> implements CapabilityManager {

    private final Map<Class<? extends Capability>, Capability> map = new HashMap<>();
    private final E entity;

    CapabilityManagerImpl(E entity) {
        this.entity = entity;
    }

    @Override
    public <T extends Capability> T addCapability(Class<T> capabilityClass) {
        instantiateCapability(capabilityClass);
        return (T) map.get(capabilityClass);
    }

    @Override
    @SuppressWarnings("unchecked")
    public <T extends Capability> T getCapability(Class<T> capabilityClass) {
        return (T) map.get(capabilityClass);
    }

    @Override
    public List<Capability> getCapabilities() {
        return map.values().stream().toList();
    }

    @Override
    public <T extends Capability> void setCapability(Class<T> capabilityClass, T capability) {
        map.put(capabilityClass, capability);
    }

    @Override
    public class_2520 writeTag() {
        class_2499 tag = new class_2499();
        map.forEach((aClass, capability) -> {
            class_2487 compoundTag = new class_2487();
            compoundTag.method_10582("className", aClass.getName());
            compoundTag.method_10566("capability", capability.writeTag());
            tag.add(compoundTag);
        });
        return tag;
    }

    @Override
    @SuppressWarnings("unchecked")
    public void readTag(class_2520 tag) {
        class_2499 listTag = (class_2499) tag;
        listTag.forEach(tagInList -> {
            class_2487 compoundTag = (class_2487) tagInList;
            try {
                String className = compoundTag.method_10558("className")
                        //? if >= 1.21.5 {
                        /*.orElseThrow()
                        *///?}
                        ;
                Class<? extends Capability> aClass = (Class<? extends Capability>) Class.forName(className);
                if (!map.containsKey(aClass)) instantiateCapability(aClass);
                map.get(aClass).readTag(compoundTag.method_10580("capability"));
            } catch (ClassNotFoundException e) {
                Haybale.LOG.error("Failed to instantiate capability from NBT", e);
            }
        });
    }

    private <T extends Capability> void instantiateCapability(Class<T> aClass) {
        map.put(aClass, CapabilityRegistrar.INSTANCE.get(aClass, entity).orElseThrow(() -> new InstantiationError("Failed to instantiate capability for class: " + aClass.getSimpleName())));
    }
}
