package com.t2pellet.haybale.common.utils.compound;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonObject;
import com.google.gson.JsonArray;
import com.google.gson.JsonNull;
import net.minecraft.class_2481;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2494;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2503;
import net.minecraft.class_2516;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.nbt.*;

import java.util.Map;

/**
 * Json to NBT converter utility
 * Based off of <a href="https://github.com/KSashaDF/JSON-to-NBT-Converter">KSashaDF's repository</a>
 */
public class JsonToNbt {

    /**
     * Converts a JSON element to an NBT tag.
     *
     * @param jsonElement Element to convert.
     * @return The NBT tag equivalent. (imperfect in certain cases)
     */
    public static class_2520 toNbt(JsonElement jsonElement) {

        // JSON Primitive
        if (jsonElement instanceof JsonPrimitive) {
            JsonPrimitive jsonPrimitive = (JsonPrimitive) jsonElement;

            if (jsonPrimitive.isBoolean()) {
                boolean value = jsonPrimitive.getAsBoolean();

                if (value) {
                    return class_2481.method_23234(true);
                } else {
                    return class_2481.method_23234(false);
                }

            } else if (jsonPrimitive.isNumber()) {
                Number number = jsonPrimitive.getAsNumber();

                if (number instanceof Byte) {
                    return class_2481.method_23233(number.byteValue());
                } else if (number instanceof Short) {
                    return class_2516.method_23254(number.shortValue());
                } else if (number instanceof Integer) {
                    return class_2497.method_23247(number.intValue());
                } else if (number instanceof Long) {
                    return class_2503.method_23251(number.longValue());
                } else if (number instanceof Float) {
                    return class_2494.method_23244(number.floatValue());
                } else if (number instanceof Double) {
                    return class_2489.method_23241(number.doubleValue());
                }

            } else if (jsonPrimitive.isString()) {
                return class_2519.method_23256(jsonPrimitive.getAsString());
            }

        } else if (jsonElement instanceof JsonArray jsonArray) {
            // JSON Array
            class_2499 nbtList = new class_2499();

            for (JsonElement element : jsonArray) {
                nbtList.add(toNbt(element));
            }

            return nbtList;
        } else if (jsonElement instanceof JsonObject) {
            // JSON Object
            JsonObject jsonObject = (JsonObject) jsonElement;
            class_2487 nbtCompound = new class_2487();

            for (Map.Entry<String, JsonElement> jsonEntry : jsonObject.entrySet()) {
                nbtCompound.method_10566(jsonEntry.getKey(), toNbt(jsonEntry.getValue()));
            }

            return nbtCompound;

        // Null - Not fully supported
        } else if (jsonElement instanceof JsonNull) {
            return new class_2487();
        }

        // Something has gone wrong, throw an error.
        throw new AssertionError();
    }
}
