/*
 * Decompiled with CFR 0.152.
 */
package com.t2pellet.haybale.common;

import com.t2pellet.haybale.Haybale;
import com.t2pellet.haybale.common.registry.api.EntryType;
import com.t2pellet.haybale.common.registry.api.RegistryClass;
import java.lang.reflect.Field;

public abstract class BaseRegistrar {
    BaseRegistrar() {
    }

    public void registerFromClass(String modid, Class<? extends RegistryClass> registerClass) {
        if (registerClass == null) {
            return;
        }
        if (registerClass.isAnnotationPresent(RegistryClass.IRegistryClass.class)) {
            RegistryClass.IRegistryClass registryClassInfo = registerClass.getAnnotation(RegistryClass.IRegistryClass.class);
            Class<?> registryType = registryClassInfo.value();
            if (this.checkIsValid(registryType)) {
                for (Field declaredField : registerClass.getDeclaredFields()) {
                    Class<?> fieldType = declaredField.getType();
                    if (!declaredField.isAnnotationPresent(RegistryClass.IRegistryEntry.class) || !EntryType.class.isAssignableFrom(fieldType)) continue;
                    try {
                        this.doGenericRegistration(modid, registryType, declaredField);
                    }
                    catch (IllegalAccessException ex) {
                        Haybale.LOG.error("Failed registration for " + modid + "for type: " + registryType.getSimpleName());
                        Haybale.LOG.error((Object)ex);
                    }
                }
            } else {
                Haybale.LOG.error("Invalid registry type: " + registryType.getName());
            }
        } else {
            Haybale.LOG.debug("Skipping registration class " + registerClass.getName() + " for " + modid + ". No IRegistryClass annotation found.");
        }
    }

    protected abstract boolean checkIsValid(Class<?> var1);

    protected abstract void doGenericRegistration(String var1, Class<?> var2, Field var3) throws IllegalAccessException;

    protected void setField(String name, Object object, Object value) {
        try {
            Field field = object.getClass().getSuperclass().getDeclaredField(name);
            field.setAccessible(true);
            field.set(object, value);
        }
        catch (Exception e) {
            Haybale.LOG.error("Reflection setField failed");
            Haybale.LOG.error((Object)e);
        }
    }
}

