/*
 * Decompiled with CFR 0.152.
 */
package com.t2pellet.haybale.fabric.network;

import com.t2pellet.haybale.Haybale;
import com.t2pellet.haybale.Services;
import com.t2pellet.haybale.common.network.api.Packet;
import com.t2pellet.haybale.common.utils.VersionHelper;
import com.t2pellet.haybale.services.IPacketHandler;
import io.netty.buffer.Unpooled;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class PacketHandler
implements IPacketHandler {
    private final Map<Class<? extends Packet>, class_2960> idMap = new HashMap<Class<? extends Packet>, class_2960>();

    public <T extends Packet> void registerServerPacket(String modid, String name, Class<T> packetClass) {
        class_2960 loc = VersionHelper.getResourceLocation(modid, name);
        this.idMap.put(packetClass, loc);
        ServerPlayNetworking.registerGlobalReceiver((class_2960)loc, (minecraftServer, serverPlayer, serverPlayNetworkHandler, packetByteBuf, packetSender) -> {
            try {
                Packet packet = (Packet)packetClass.getDeclaredConstructor(class_2540.class).newInstance(packetByteBuf);
                Services.SIDE.scheduleServer(packet.getExecutor());
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                Haybale.LOG.error("Error: Failed to instantiate packet - " + String.valueOf(loc));
            }
        });
    }

    public <T extends Packet> void registerClientPacket(String modid, String name, Class<T> packetClass) {
        class_2960 loc = VersionHelper.getResourceLocation(modid, name);
        this.idMap.put(packetClass, loc);
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            this._registerClientPacket(loc, packetClass);
        }
    }

    @Environment(value=EnvType.CLIENT)
    private <T extends Packet> void _registerClientPacket(class_2960 id, Class<T> packetClass) {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)id, (client, handler, buf, responseSender) -> {
            try {
                Packet packet = (Packet)packetClass.getDeclaredConstructor(class_2540.class).newInstance(buf);
                Services.SIDE.scheduleClient(packet.getExecutor());
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                Haybale.LOG.error("Error: Failed to instantiate packet - " + String.valueOf(id));
            }
        });
    }

    @Override
    public <T extends Packet> void sendToServer(T packet) {
        class_2540 data = new class_2540(Unpooled.buffer());
        packet.encode(data);
        ClientPlayNetworking.send((class_2960)this.idMap.get(packet.getClass()), (class_2540)data);
    }

    @Override
    public <T extends Packet> void sendTo(T packet, class_3222 player) {
        class_2540 data = new class_2540(Unpooled.buffer());
        packet.encode(data);
        ServerPlayNetworking.send((class_3222)player, (class_2960)this.idMap.get(packet.getClass()), (class_2540)data);
    }

    @Override
    public <T extends Packet> void sendTo(T packet, class_3222 ... players) {
        class_2540 data = new class_2540(Unpooled.buffer());
        class_2960 id = this.idMap.get(packet.getClass());
        packet.encode(data);
        for (class_3222 player : players) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)id, (class_2540)data);
        }
    }

    @Override
    public <T extends Packet> void sendInRange(T packet, class_1297 e, float range) {
        class_238 box = new class_238(e.method_24515()).method_1014((double)range);
        class_1937 level = VersionHelper.getLevel(e);
        this.sendInArea(packet, level, box);
    }

    @Override
    public <T extends Packet> void sendInArea(T packet, class_1937 world, class_238 area) {
        class_3222[] players = (class_3222[])((class_3218)world).method_18456().stream().filter(p -> area.method_1006(p.method_19538())).toArray(class_3222[]::new);
        this.sendTo(packet, players);
    }
}

