package com.t2pellet.haybale.common.entity;

import com.t2pellet.haybale.common.capability.api.CapabilityManager;
import com.t2pellet.haybale.common.capability.api.ICapabilityHaver;
import com.t2pellet.haybale.common.capability.registry.ExampleCapability;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.level.Level;

public class ExampleEntity extends Cow implements ICapabilityHaver {

    CapabilityManager capabilities = CapabilityManager.newInstance(this);
    private final ExampleCapability example;

    public ExampleEntity(EntityType<? extends Cow> arg, Level arg2) {
        super(arg, arg2);
        example = capabilities.addCapability(ExampleCapability.class);
    }

    @Override
    public CapabilityManager getCapabilityManager() {
        return capabilities;
    }

    @Override
    public void baseTick() {
        super.baseTick();
        if (random.nextInt(10) == 0) {
            example.decrement();
        }
        if (example.count() == 0) {
            kill();
        }
    }


}
