/*
 * Decompiled with CFR 0.152.
 */
package com.t2pellet.haybale.common.config.api;

import com.t2pellet.haybale.Services;
import com.t2pellet.haybale.common.config.api.property.BoolProperty;
import com.t2pellet.haybale.common.config.api.property.ConfigProperty;
import com.t2pellet.haybale.common.config.api.property.FloatProperty;
import com.t2pellet.haybale.common.config.api.property.IntProperty;
import com.t2pellet.haybale.common.config.api.property.ListProperty;
import com.t2pellet.haybale.common.config.api.property.StringProperty;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import org.ini4j.Ini;
import org.ini4j.Profile;
import org.jetbrains.annotations.NotNull;

public class Config {
    private static final String CONFIG_DIR = Services.PLATFORM.getGameDir() + "/config/";
    private final File file;
    private final Ini ini;

    protected Config(String modid) throws IOException, IllegalAccessException {
        this.file = new File(CONFIG_DIR + modid + ".ini");
        if (!this.file.exists()) {
            this.file.createNewFile();
        }
        this.ini = new Ini(this.file);
    }

    public void save() throws IOException, IllegalAccessException {
        if (!this.ini.getFile().exists()) {
            this.ini.getFile().createNewFile();
        }
        this.ini.clear();
        if (this.getClass().isAnnotationPresent(ModConfig.class)) {
            ModConfig modConfig = this.getClass().getAnnotation(ModConfig.class);
            this.ini.setComment(modConfig.comment());
        }
        for (Class<?> aClass : this.getClass().getDeclaredClasses()) {
            if (!aClass.isAnnotationPresent(Section.class)) continue;
            Section sectionAnnotation = aClass.getAnnotation(Section.class);
            this.ini.putComment((Object)sectionAnnotation.name(), sectionAnnotation.description());
            Profile.Section section = this.ini.add(sectionAnnotation.name());
            for (Field declaredField : aClass.getDeclaredFields()) {
                if (!declaredField.isAnnotationPresent(Entry.class)) continue;
                Entry entryAnnotation = declaredField.getAnnotation(Entry.class);
                Object fieldValue = declaredField.get(null);
                declaredField.setAccessible(true);
                if (!(fieldValue instanceof ConfigProperty)) continue;
                ConfigProperty property = (ConfigProperty)fieldValue;
                Object value = property.get();
                section.add(declaredField.getName(), value);
                section.putComment((Object)declaredField.getName(), entryAnnotation.comment());
            }
        }
        this.ini.store();
    }

    public void load() throws IllegalAccessException {
        Class<?>[] declaredClasses;
        if (this.ini.isEmpty() || this.ini.getFile().length() == 0L) {
            return;
        }
        for (Class<?> declaredClass : declaredClasses = this.getClass().getDeclaredClasses()) {
            Section sectionAnnotation;
            Profile.Section section;
            if (!declaredClass.isAnnotationPresent(Section.class) || (section = (Profile.Section)this.ini.get((Object)(sectionAnnotation = declaredClass.getAnnotation(Section.class)).name())) == null) continue;
            this.loadSection(declaredClass, section);
        }
    }

    private void loadSection(Class<?> sectionClass, @NotNull Profile.Section section) throws IllegalAccessException {
        for (Field declaredField : sectionClass.getDeclaredFields()) {
            Object fieldValue = declaredField.get(null);
            if (!(fieldValue instanceof ConfigProperty)) continue;
            ConfigProperty property = (ConfigProperty)fieldValue;
            if (!section.containsKey((Object)declaredField.getName())) continue;
            if (property instanceof IntProperty) {
                IntProperty intProperty = (IntProperty)property;
                int value = (Integer)section.get((Object)declaredField.getName(), Integer.class);
                intProperty.set(value);
                continue;
            }
            if (property instanceof FloatProperty) {
                FloatProperty floatProperty = (FloatProperty)property;
                float value = ((Float)section.get((Object)declaredField.getName(), Float.class)).floatValue();
                floatProperty.set(Float.valueOf(value));
                continue;
            }
            if (property instanceof BoolProperty) {
                BoolProperty boolProperty = (BoolProperty)property;
                boolean value = (Boolean)section.get((Object)declaredField.getName(), Boolean.class);
                boolProperty.set(value);
                continue;
            }
            if (property instanceof StringProperty) {
                StringProperty stringProperty = (StringProperty)property;
                String value = (String)section.get((Object)declaredField.getName());
                stringProperty.set(value);
                continue;
            }
            if (!(property instanceof ListProperty)) continue;
            ListProperty listProperty = (ListProperty)property;
            String strValue = (String)section.get((Object)declaredField.getName(), String.class);
            listProperty.setValue(strValue);
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface ModConfig {
        public String comment();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface Section {
        public String name();

        public String description();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Entry {
        public String comment();
    }
}

