/*
 * Decompiled with CFR 0.152.
 */
package com.t2pellet.haybale.common.config.api.property;

import com.t2pellet.haybale.common.config.api.property.ConfigProperty;
import com.t2pellet.haybale.common.config.api.property.PropertyType;
import com.t2pellet.haybale.common.config.api.property.StringProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ListProperty<T>
extends ConfigProperty<List<T>> {
    private final PropertyType<T> type;
    private StringProperty.Validator validator;

    public static ListProperty<String> of(List<String> initialValue, StringProperty.Validator validator) {
        ListProperty<String> stringListProperty = new ListProperty<String>(PropertyType.STRING, new ArrayList<String>(initialValue));
        stringListProperty.validator = validator;
        return stringListProperty;
    }

    public static <R> ListProperty<R> of(PropertyType<R> type, List<R> initialValue) {
        if (type == PropertyType.BOOL) {
            throw new IllegalArgumentException("No support for bool lists. Sorry");
        }
        return new ListProperty<R>(type, new ArrayList<R>(initialValue));
    }

    public PropertyType<T> getType() {
        return this.type;
    }

    private ListProperty(PropertyType<T> type, List<T> value) {
        super(value);
        this.type = type;
    }

    @Override
    public void set(List<T> value) {
        if (this.validator != null) {
            List<Object> filteredList = value.stream().filter(val -> this.validator.validate((String)val)).toList();
            super.set(filteredList);
        } else {
            super.set(value);
        }
    }

    public void setValue(String value) {
        List<String> stringList = Arrays.asList(value.replaceAll("[\\[\\] \" ]", "").split("\\s*,\\s*"));
        List<Object> typeList = stringList.stream().map(this::convertFromStr).toList();
        this.set(typeList);
    }

    private T convertFromStr(String string) {
        if (this.type == PropertyType.INT) {
            return (T)Integer.valueOf(Integer.parseInt(string));
        }
        if (this.type == PropertyType.FLOAT) {
            return (T)Float.valueOf(Float.parseFloat(string));
        }
        if (this.type == PropertyType.BOOL) {
            return (T)Boolean.valueOf(Boolean.parseBoolean(string));
        }
        return (T)string;
    }
}

