package com.t2pellet.haybale.common.capability.registry;

import com.t2pellet.haybale.common.capability.api.Capability;
import com.t2pellet.haybale.common.capability.api.ICapabilityHaver;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1297;

class CapabilityRegistrarImpl implements CapabilityRegistrar {

    private final Map<Class<?>, CapabilityFactory<?>> capabilityFactoryMap = new HashMap<>();

    @Override
    public <T extends Capability> void register(Class<T> cap, CapabilityFactory<T> factory) {
        capabilityFactoryMap.put(cap, factory);
    }

    @Override
    @SuppressWarnings("unchecked")
    public <T extends Capability, E extends class_1297 & ICapabilityHaver> Optional<T> get(Class<T> cap, E entity) {
        CapabilityFactory<T> factory = (CapabilityFactory<T>) capabilityFactoryMap.get(cap);
        if (factory != null) {
            return Optional.of(factory.get(entity));
        }
        return Optional.empty();
    }

}
