package com.t2pellet.haybale.common.capability.registry;

import com.t2pellet.haybale.common.capability.api.AbstractCapability;
import com.t2pellet.haybale.common.capability.api.ICapabilityHaver;
import com.t2pellet.haybale.common.utils.VersionHelper;
import net.minecraft.class_1297;
import net.minecraft.class_2487;
import net.minecraft.class_2520;

public class ExampleCapabilityImpl<E extends class_1297 & ICapabilityHaver> extends AbstractCapability<E> implements ExampleCapability {

    private int lifeTicks = 20;

    protected ExampleCapabilityImpl(E entity) {
        super(entity);
    }

    @Override
    public int count() {
        return lifeTicks;
    }

    public void decrement() {
        lifeTicks -= 1;
        synchronize();
    }

    @Override
    public class_2520 writeTag() {
        class_2487 tag = new class_2487();
        tag.method_10569("lifeTicks", lifeTicks);
        return tag;
    }

    @Override
    public void readTag(class_2520 tag) {
        class_2487 compoundTag = (class_2487) tag;
        //? if <= 1.21.4 {
        lifeTicks = compoundTag.method_10550("lifeTicks");
        //?} else {
        /*lifeTicks = compoundTag.getInt("lifeTicks").orElseThrow();
        *///?}
    }
}
