/*
 * Decompiled with CFR 0.152.
 */
package com.t2pellet.haybale.fabric.network;

import com.t2pellet.haybale.Haybale;
import com.t2pellet.haybale.Services;
import com.t2pellet.haybale.common.network.api.Packet;
import com.t2pellet.haybale.common.utils.VersionHelper;
import com.t2pellet.haybale.services.IPacketHandler;
import io.netty.buffer.Unpooled;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

public class PacketHandler
implements IPacketHandler {
    private final Map<Class<? extends Packet>, class_2960> idMap = new HashMap<Class<? extends Packet>, class_2960>();

    private static <T extends Packet> class_9139<class_2540, FabricPacket<T>> getCodec(Class<T> packetClass, class_2960 id) {
        return class_9139.method_56437((packetByteBuf, fabricPacket) -> fabricPacket.encode((class_2540)packetByteBuf), packetByteBuf -> {
            try {
                Packet packet = (Packet)packetClass.getDeclaredConstructor(class_2540.class).newInstance(packetByteBuf);
                return new FabricPacket<Packet>(packet, id);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                Haybale.LOG.error("Error: Failed to instantiate packet - " + String.valueOf(id));
                return null;
            }
        });
    }

    public <T extends Packet> void registerServerPacket(String modid, String name, Class<T> packetClass) {
        class_2960 loc = VersionHelper.getResourceLocation(modid, name);
        this.idMap.put(packetClass, loc);
        class_8710.class_9154 type = new class_8710.class_9154(loc);
        PayloadTypeRegistry.playC2S().register(type, PacketHandler.getCodec(packetClass, loc));
        ServerPlayNetworking.registerGlobalReceiver((class_8710.class_9154)type, (payload, context) -> Services.SIDE.scheduleServer(payload.executor()));
    }

    public <T extends Packet> void registerClientPacket(String modid, String name, Class<T> packetClass) {
        class_2960 loc = VersionHelper.getResourceLocation(modid, name);
        this.idMap.put(packetClass, loc);
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            this._registerClientPacket(loc, packetClass);
        }
    }

    @Environment(value=EnvType.CLIENT)
    private <T extends Packet> void _registerClientPacket(class_2960 id, Class<T> packetClass) {
        class_8710.class_9154 type = new class_8710.class_9154(id);
        PayloadTypeRegistry.playS2C().register(type, PacketHandler.getCodec(packetClass, id));
        ClientPlayNetworking.registerGlobalReceiver((class_8710.class_9154)type, (payload, context) -> Services.SIDE.scheduleClient(payload.executor()));
    }

    @Override
    public <T extends Packet> void sendToServer(T packet) {
        class_2540 data = new class_2540(Unpooled.buffer());
        packet.encode(data);
        class_2960 id = this.idMap.get(packet.getClass());
        FabricPacket<T> fabricPacket = new FabricPacket<T>(packet, id);
        ClientPlayNetworking.send(fabricPacket);
    }

    @Override
    public <T extends Packet> void sendTo(T packet, class_3222 player) {
        class_2540 data = new class_2540(Unpooled.buffer());
        packet.encode(data);
        class_2960 id = this.idMap.get(packet.getClass());
        FabricPacket<T> fabricPacket = new FabricPacket<T>(packet, id);
        ServerPlayNetworking.send((class_3222)player, fabricPacket);
    }

    @Override
    public <T extends Packet> void sendTo(T packet, class_3222 ... players) {
        class_2540 data = new class_2540(Unpooled.buffer());
        class_2960 id = this.idMap.get(packet.getClass());
        FabricPacket<T> fabricPacket = new FabricPacket<T>(packet, id);
        for (class_3222 player : players) {
            ServerPlayNetworking.send((class_3222)player, fabricPacket);
        }
    }

    @Override
    public <T extends Packet> void sendInRange(T packet, class_1297 e, float range) {
        class_238 box = new class_238(e.method_24515()).method_1014((double)range);
        class_1937 level = VersionHelper.getLevel(e);
        this.sendInArea(packet, level, box);
    }

    @Override
    public <T extends Packet> void sendInArea(T packet, class_1937 world, class_238 area) {
        class_3222[] players = (class_3222[])((class_3218)world).method_18456().stream().filter(p -> area.method_1006(p.method_19538())).toArray(class_3222[]::new);
        this.sendTo(packet, players);
    }

    private static class FabricPacket<T extends Packet>
    implements class_8710 {
        private final T packet;
        private final class_8710.class_9154<FabricPacket<T>> type;

        public FabricPacket(T packet, class_2960 id) {
            this.packet = packet;
            this.type = new class_8710.class_9154(id);
        }

        @NotNull
        public class_8710.class_9154<FabricPacket<T>> method_56479() {
            return this.type;
        }

        public void encode(class_2540 packetByteBuf) {
            ((Packet)this.packet).encode(packetByteBuf);
        }

        public Runnable executor() {
            return ((Packet)this.packet).getExecutor();
        }
    }
}

