/*
 * Decompiled with CFR 0.152.
 */
package com.t2pellet.haybale.common.utils.compound;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Map;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;

public class JsonToNbt {
    public static Tag toNbt(JsonElement jsonElement) {
        if (jsonElement instanceof JsonPrimitive) {
            JsonPrimitive jsonPrimitive = (JsonPrimitive)jsonElement;
            if (jsonPrimitive.isBoolean()) {
                boolean value = jsonPrimitive.getAsBoolean();
                if (value) {
                    return ByteTag.m_128273_((boolean)true);
                }
                return ByteTag.m_128273_((boolean)false);
            }
            if (jsonPrimitive.isNumber()) {
                Number number = jsonPrimitive.getAsNumber();
                if (number instanceof Byte) {
                    return ByteTag.m_128266_((byte)number.byteValue());
                }
                if (number instanceof Short) {
                    return ShortTag.m_129258_((short)number.shortValue());
                }
                if (number instanceof Integer) {
                    return IntTag.m_128679_((int)number.intValue());
                }
                if (number instanceof Long) {
                    return LongTag.m_128882_((long)number.longValue());
                }
                if (number instanceof Float) {
                    return FloatTag.m_128566_((float)number.floatValue());
                }
                if (number instanceof Double) {
                    return DoubleTag.m_128500_((double)number.doubleValue());
                }
            } else if (jsonPrimitive.isString()) {
                return StringTag.m_129297_((String)jsonPrimitive.getAsString());
            }
        } else {
            if (jsonElement instanceof JsonArray) {
                JsonArray jsonArray = (JsonArray)jsonElement;
                ListTag nbtList = new ListTag();
                for (JsonElement element : jsonArray) {
                    nbtList.add((Object)JsonToNbt.toNbt(element));
                }
                return nbtList;
            }
            if (jsonElement instanceof JsonObject) {
                JsonObject jsonObject = (JsonObject)jsonElement;
                CompoundTag nbtCompound = new CompoundTag();
                for (Map.Entry jsonEntry : jsonObject.entrySet()) {
                    nbtCompound.m_128365_((String)jsonEntry.getKey(), JsonToNbt.toNbt((JsonElement)jsonEntry.getValue()));
                }
                return nbtCompound;
            }
            if (jsonElement instanceof JsonNull) {
                return new CompoundTag();
            }
        }
        throw new AssertionError();
    }
}

