/*
 * Decompiled with CFR 0.152.
 */
package com.t2pellet.haybale.common.utils.compound;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;

public class NbtToJson {
    public static JsonElement toJson(Tag nbtElement) {
        return NbtToJson.toJson(nbtElement, ConversionMode.RAW);
    }

    public static JsonElement toJson(Tag nbtElement, ConversionMode mode) {
        if (nbtElement instanceof NumericTag) {
            NumericTag nbtNumber = (NumericTag)nbtElement;
            switch (mode.ordinal()) {
                case 1: {
                    if (nbtNumber instanceof ByteTag) {
                        ByteTag nbtByte = (ByteTag)nbtNumber;
                        byte value = nbtByte.m_7063_();
                        switch (value) {
                            case 0: {
                                return new JsonPrimitive(Boolean.valueOf(false));
                            }
                            case 1: {
                                return new JsonPrimitive(Boolean.valueOf(true));
                            }
                        }
                    }
                }
                case 0: {
                    Number number = nbtNumber.m_8103_();
                    return new JsonPrimitive(number);
                }
            }
        } else {
            if (nbtElement instanceof StringTag) {
                StringTag nbtString = (StringTag)nbtElement;
                String string = nbtString.m_7916_();
                return new JsonPrimitive(string);
            }
            if (nbtElement instanceof ListTag) {
                ListTag nbtList = (ListTag)nbtElement;
                JsonArray jsonArray = new JsonArray();
                for (Tag nbtBase : nbtList) {
                    jsonArray.add(NbtToJson.toJson(nbtBase, mode));
                }
                return jsonArray;
            }
            if (nbtElement instanceof CompoundTag) {
                CompoundTag nbtCompound = (CompoundTag)nbtElement;
                JsonObject jsonObject = new JsonObject();
                for (String key : nbtCompound.m_128431_()) {
                    Tag entry = nbtCompound.m_128423_(key);
                    jsonObject.add(key, NbtToJson.toJson(entry, mode));
                }
                return jsonObject;
            }
            if (nbtElement instanceof EndTag) {
                throw new AssertionError();
            }
        }
        throw new UnsupportedOperationException();
    }

    public static enum ConversionMode {
        RAW,
        JSON;

    }
}

