/*
 * Decompiled with CFR 0.152.
 */
package com.t2pellet.haybale.forge.network;

import com.t2pellet.haybale.Haybale;
import com.t2pellet.haybale.Services;
import com.t2pellet.haybale.common.network.api.Packet;
import com.t2pellet.haybale.common.utils.VersionHelper;
import com.t2pellet.haybale.services.IPacketHandler;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class PacketHandler
implements IPacketHandler {
    private final String PROTOCOL_VERSION = "4";
    private final Map<ResourceLocation, Integer> idMap = new HashMap<ResourceLocation, Integer>();
    private final SimpleChannel INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)VersionHelper.getResourceLocation("haybale", "main"), () -> "4", "4"::equals, "4"::equals);

    public void registerServerPacket(String modid, String name, Class<? extends Packet> packetClass) {
        this.idMap.put(VersionHelper.getResourceLocation(modid, name), this.idMap.size());
        this.registerPacket(modid, name, packetClass);
    }

    public void registerClientPacket(String modid, String name, Class<? extends Packet> packetClass) {
        this.idMap.put(VersionHelper.getResourceLocation(modid, name), this.idMap.size());
        this.registerPacket(modid, name, packetClass);
    }

    private <T extends Packet> void registerPacket(String modid, String name, Class<T> packetClass) {
        ResourceLocation id = VersionHelper.getResourceLocation(modid, name);
        this.INSTANCE.registerMessage(this.idMap.get(id).intValue(), packetClass, Packet::encode, friendlyByteBuf -> {
            try {
                return (Packet)packetClass.getDeclaredConstructor(FriendlyByteBuf.class).newInstance(friendlyByteBuf);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                Haybale.LOG.error("Error: Failed to instantiate packet - " + String.valueOf(id));
                return null;
            }
        }, (t, contextSupplier) -> {
            if (((NetworkEvent.Context)contextSupplier.get()).getDirection().getReceptionSide().isClient()) {
                Services.SIDE.scheduleClient(t.getExecutor());
            } else {
                Services.SIDE.scheduleServer(t.getExecutor());
            }
            ((NetworkEvent.Context)contextSupplier.get()).setPacketHandled(true);
        });
    }

    @Override
    public <T extends Packet> void sendToServer(T packet) {
        this.INSTANCE.sendToServer(packet);
    }

    @Override
    public <T extends Packet> void sendTo(T packet, ServerPlayer player) {
        this.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), packet);
    }

    @Override
    public <T extends Packet> void sendTo(T packet, ServerPlayer ... players) {
        for (ServerPlayer player : players) {
            this.sendTo(packet, player);
        }
    }

    @Override
    public <T extends Packet> void sendInRange(T packet, Entity e, float range) {
        AABB box = new AABB(e.m_142538_()).m_82400_((double)range);
        Level level = VersionHelper.getLevel(e);
        this.sendInArea(packet, level, box);
    }

    @Override
    public <T extends Packet> void sendInArea(T packet, Level world, AABB area) {
        ServerPlayer[] players = (ServerPlayer[])((ServerLevel)world).m_6907_().stream().filter(p -> area.m_82390_(p.m_20182_())).toArray(ServerPlayer[]::new);
        this.sendTo(packet, players);
    }
}

