package com.t2pellet.haybale.common.network.capability;

import com.t2pellet.haybale.common.capability.api.Capability;
import com.t2pellet.haybale.common.capability.api.ICapabilityHaver;
import com.t2pellet.haybale.common.network.api.Packet;
import net.minecraft.class_1297;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_310;

public class CapabilityPacket<E extends class_1297 & ICapabilityHaver> extends Packet {

    private E capabilityHaver;
    private final Class<? extends Capability> clazz;

    public CapabilityPacket(E capabilityHaver, Class<? extends Capability> clazz) {
        super();
        this.capabilityHaver = capabilityHaver;
        this.clazz = (Class<? extends Capability>) clazz.getInterfaces()[0];
    }

    public CapabilityPacket(class_2540 byteBuf) throws ClassNotFoundException {
        super(byteBuf);
        String classStr = tag.method_10558("class")/*? if >= 1.21.5 {*/.orElseThrow()/*?}*/;
        this.clazz = (Class<? extends Capability>) Class.forName(classStr);
    }

    @Override
    public Runnable getExecutor() {
        return () -> {
            class_2520 data = tag.method_10580("data");
            int id = tag.method_10550("entity")/*? if >= 1.21.5 {*/.orElseThrow()/*?}*/;
            this.capabilityHaver = (E) class_310.method_1551().field_1687.method_8469(id);
            if (this.capabilityHaver != null) {
                capabilityHaver.getCapabilityManager().getCapability(clazz).readTag(data);
            }
        };
    }

    @Override
    public void encode(class_2540 byteBuf) {
        Capability capability = capabilityHaver.getCapabilityManager().getCapability(clazz);
        tag.method_10569("entity", capabilityHaver.method_5628());
        tag.method_10582("class", clazz.getName());
        tag.method_10566("data", capability.writeTag());
        super.encode(byteBuf);
    }
}
