package com.t2pellet.haybale.mixin;

import com.t2pellet.haybale.common.capability.api.ICapabilityHaver;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import java.util.Optional;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2520;
import net.minecraft.class_5699;
import com.google.gson.JsonElement;
import com.t2pellet.haybale.common.utils.compound.JsonToNbt;
import com.t2pellet.haybale.common.utils.compound.NbtToJson;

@Mixin(class_1309.class)
public class EntityMixin {

    @Inject(method = "readAdditionalSaveData", at = @At("TAIL"))
    //? if > 1.21.5 {
    public void readFromTag(class_11368 valueInput, CallbackInfo ci) {
        class_1297 e = (class_1297) (Object) this;
        if (e instanceof ICapabilityHaver capabilityHaver) {
            Optional<JsonElement> json = valueInput.method_71426("capabilityData", class_5699.field_40721);
            if (json.isPresent()) {
                class_2520 tag = JsonToNbt.toNbt(json.get());
                capabilityHaver.getCapabilityManager().readTag(tag);
            }
        }
    }
    //?} else {
    /*public void readFromTag(CompoundTag tag, CallbackInfo ci) {
        Entity e = (Entity) (Object) this;
        if (e instanceof ICapabilityHaver capabilityHaver && tag.contains("capabilities")) {
            capabilityHaver.getCapabilityManager().readTag(tag.get("capabilities"));
        }
    }
    *///?}

    @Inject(method = "addAdditionalSaveData", at = @At("TAIL"))
    //? if > 1.21.5 {
    public void writeToTag(class_11372 valueOutput, CallbackInfo ci) {
        class_1297 e = (class_1297) (Object) this;
        if (e instanceof ICapabilityHaver capabilityHaver) {
            class_2520 capabilityTag = capabilityHaver.getCapabilityManager().writeTag();
            JsonElement json = NbtToJson.toJson(capabilityTag);
            valueOutput.method_71468("capabilityData", class_5699.field_40721, json);
        }
    }
    //?} else {
    /*public void writeToTag(CompoundTag tag, CallbackInfo ci) {
        Entity e = (Entity) (Object) this;
        if (e instanceof ICapabilityHaver capabilityHaver) {
            Tag capabilityTag = capabilityHaver.getCapabilityManager().writeTag();
            tag.put("capabilities", capabilityTag);
        }
    }
    *///?}

}
