/*
 * Decompiled with CFR 0.152.
 */
package com.t2pellet.haybale.common.capability.api;

import com.t2pellet.haybale.Haybale;
import com.t2pellet.haybale.common.capability.api.Capability;
import com.t2pellet.haybale.common.capability.api.CapabilityManager;
import com.t2pellet.haybale.common.capability.registry.CapabilityRegistrar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;

class CapabilityManagerImpl<E extends class_1297>
implements CapabilityManager {
    private final Map<Class<? extends Capability>, Capability> map = new HashMap<Class<? extends Capability>, Capability>();
    private final E entity;

    CapabilityManagerImpl(E entity) {
        this.entity = entity;
    }

    @Override
    public <T extends Capability> T addCapability(Class<T> capabilityClass) {
        this.instantiateCapability(capabilityClass);
        return (T)this.map.get(capabilityClass);
    }

    @Override
    public <T extends Capability> T getCapability(Class<T> capabilityClass) {
        return (T)this.map.get(capabilityClass);
    }

    public List<Capability> getCapabilities() {
        return this.map.values().stream().toList();
    }

    @Override
    public <T extends Capability> void setCapability(Class<T> capabilityClass, T capability) {
        this.map.put(capabilityClass, capability);
    }

    @Override
    public class_2520 writeTag() {
        class_2499 tag = new class_2499();
        this.map.forEach((aClass, capability) -> {
            class_2487 compoundTag = new class_2487();
            compoundTag.method_10582("className", aClass.getName());
            compoundTag.method_10566("capability", capability.writeTag());
            tag.add((Object)compoundTag);
        });
        return tag;
    }

    @Override
    public void readTag(class_2520 tag) {
        class_2499 listTag = (class_2499)tag;
        listTag.forEach(tagInList -> {
            class_2487 compoundTag = (class_2487)tagInList;
            try {
                String className = (String)compoundTag.method_10558("className").orElseThrow();
                Class<?> aClass = Class.forName(className);
                if (!this.map.containsKey(aClass)) {
                    this.instantiateCapability(aClass);
                }
                this.map.get(aClass).readTag(compoundTag.method_10580("capability"));
            }
            catch (ClassNotFoundException e) {
                Haybale.LOG.error("Failed to instantiate capability from NBT", (Throwable)e);
            }
        });
    }

    private <T extends Capability> void instantiateCapability(Class<T> aClass) {
        this.map.put(aClass, (Capability)CapabilityRegistrar.INSTANCE.get(aClass, this.entity).orElseThrow(() -> new InstantiationError("Failed to instantiate capability for class: " + aClass.getSimpleName())));
    }
}

