/*
 * Decompiled with CFR 0.152.
 */
package com.t2pellet.haybale.fabric.services;

import com.t2pellet.haybale.fabric.HaybaleFabric;
import com.t2pellet.haybale.services.ISidedExecutor;
import java.util.PriorityQueue;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public class SidedExecutor
implements ISidedExecutor {
    private final PriorityQueue<PQEntry> pq = new PriorityQueue();
    private long tick = 0L;

    @Override
    @Environment(value=EnvType.CLIENT)
    public void scheduleClient(Runnable runnable) {
        class_310.method_1551().execute(runnable);
    }

    @Override
    public void scheduleServer(Runnable runnable) {
        HaybaleFabric.getServer().execute(runnable);
    }

    @Override
    public void scheduleServer(int ticks, Runnable runnable) {
        this.pq.add(new PQEntry(runnable, this.tick + (long)ticks));
    }

    public void onServerTick(MinecraftServer server) {
        ++this.tick;
        PQEntry top = this.pq.peek();
        if (top != null && top.tick < this.tick) {
            this.pq.poll();
            server.execute(top.runnable);
        }
    }

    static class PQEntry
    implements Comparable<PQEntry> {
        private final Runnable runnable;
        private final Long tick;

        public PQEntry(Runnable runnable, long tick) {
            this.runnable = runnable;
            this.tick = tick;
        }

        @Override
        public int compareTo(@NotNull PQEntry o) {
            return this.tick.compareTo(o.tick);
        }
    }
}

