/*
 * Decompiled with CFR 0.152.
 */
package net.prehistoricnaturefossils.blocks.base;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.lepidodendron.block.base.IArchiveInvertebrate;
import net.lepidodendron.block.base.IArchivePlant;
import net.lepidodendron.block.base.IArchiveStatic;
import net.lepidodendron.block.base.IArchiveVertebrate;
import net.lepidodendron.util.IDimensionRestricted;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;
import net.prehistoricnaturefossils.FossilBlockDrops;
import net.prehistoricnaturefossils.PrehistoricNatureFossils;
import net.prehistoricnaturefossils.blocks.base.IAdvancementGranterFossil;
import net.prehistoricnaturefossils.items.IHasModel;
import net.prehistoricnaturefossils.tile.base.TileEntityFossilBase;
import net.prehistoricnaturefossils.triggers.CustomTrigger;

public abstract class BlockSkeletonBase
extends Block
implements IDimensionRestricted,
IHasModel,
IAdvancementGranterFossil {
    public BlockSkeletonBase() {
        super(Material.field_151576_e);
        this.func_149672_a(PrehistoricNatureFossils.SKELETON);
        this.func_149711_c(0.5f);
        this.func_149752_b(1.0f);
        this.func_149715_a(0.0f);
        this.func_149713_g(0);
        this.func_149647_a(PrehistoricNatureFossils.CREATIVE_TAB);
    }

    public abstract int stages();

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, World player, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add("When completed contains " + this.stages() + " part(s)");
        super.func_190948_a(stack, player, tooltip, advanced);
    }

    public SoundEvent soundPlace() {
        return SoundEvents.field_187868_fj;
    }

    public SoundEvent soundTurn() {
        return SoundEvents.field_187864_fh;
    }

    public SoundEvent soundFrame() {
        return SoundEvents.field_187772_dn;
    }

    @Nullable
    public String getDNACompat() {
        return null;
    }

    @Override
    public void registerModels() {
        PrehistoricNatureFossils.proxy.registerItemRenderer(Item.func_150898_a((Block)this), 0, "inventory");
    }

    public int getRotation(World world, BlockPos pos) {
        int currentRotation = 0;
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity != null && tileEntity.getTileData().func_74764_b("rotation")) {
            currentRotation = tileEntity.getTileData().func_74762_e("rotation");
        }
        return currentRotation;
    }

    public int getStage(World world, BlockPos pos) {
        int currentStage = 1;
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity != null && tileEntity.getTileData().func_74764_b("stage")) {
            currentStage = tileEntity.getTileData().func_74762_e("stage");
        }
        return currentStage;
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return true;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public boolean func_189539_a(IBlockState state, World worldIn, BlockPos pos, int eventID, int eventParam) {
        super.func_189539_a(state, worldIn, pos, eventID, eventParam);
        TileEntity tileentity = worldIn.func_175625_s(pos);
        return tileentity == null ? false : tileentity.func_145842_c(eventID, eventParam);
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return new ItemStack(Items.field_190931_a, 1).func_77973_b();
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        super.func_176213_c(world, pos, state);
        if (!world.field_72995_K) {
            TileEntity tileEntity = world.func_175625_s(pos);
            IBlockState blockstate = world.func_180495_p(pos);
            if (tileEntity != null) {
                tileEntity.getTileData().func_74768_a("rotation", 0);
                tileEntity.getTileData().func_74768_a("stage", 1);
            }
            world.func_184138_a(pos, blockstate, blockstate, 3);
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof TileEntityFossilBase) {
            NBTTagCompound entityNBT;
            NBTTagCompound stackNBT;
            ItemStack stack;
            int i;
            int stages = this.getStage(world, pos);
            for (i = 0; i < ((TileEntityFossilBase)te).dim01; ++i) {
                --stages;
                stack = new ItemStack((Block)this, 1);
                if (this instanceof IArchiveVertebrate) {
                    stackNBT = new NBTTagCompound();
                    entityNBT = new NBTTagCompound();
                    entityNBT.func_74778_a("id", "");
                    stackNBT.func_74782_a("PFMob", (NBTBase)entityNBT);
                    stack.func_77982_d(stackNBT);
                    stack.func_77978_p().func_74778_a("mobtype", "vertebrate");
                    stack.func_77978_p().func_74768_a("period", 1);
                } else if (this instanceof IArchiveInvertebrate) {
                    stackNBT = new NBTTagCompound();
                    entityNBT = new NBTTagCompound();
                    entityNBT.func_74778_a("id", "");
                    stackNBT.func_74782_a("PFMob", (NBTBase)entityNBT);
                    stack.func_77982_d(stackNBT);
                    stack.func_77978_p().func_74778_a("mobtype", "invertebrate");
                    stack.func_77978_p().func_74768_a("period", 1);
                } else if (this instanceof IArchiveStatic) {
                    stackNBT = new NBTTagCompound();
                    entityNBT = new NBTTagCompound();
                    entityNBT.func_74778_a("id", "");
                    stackNBT.func_74782_a("PFStatic", (NBTBase)entityNBT);
                    stack.func_77982_d(stackNBT);
                    stack.func_77978_p().func_74768_a("period", 1);
                } else if (this instanceof IArchivePlant) {
                    stackNBT = new NBTTagCompound();
                    entityNBT = new NBTTagCompound();
                    entityNBT.func_74778_a("id", "");
                    stackNBT.func_74782_a("PFPlant", (NBTBase)entityNBT);
                    stack.func_77982_d(stackNBT);
                    stack.func_77978_p().func_74768_a("period", 1);
                }
                BlockSkeletonBase.func_180635_a((World)world, (BlockPos)pos, (ItemStack)stack);
            }
            for (i = 0; i < ((TileEntityFossilBase)te).dim02; ++i) {
                --stages;
                stack = new ItemStack((Block)this, 1);
                if (this instanceof IArchiveVertebrate) {
                    stackNBT = new NBTTagCompound();
                    entityNBT = new NBTTagCompound();
                    entityNBT.func_74778_a("id", "");
                    stackNBT.func_74782_a("PFMob", (NBTBase)entityNBT);
                    stack.func_77982_d(stackNBT);
                    stack.func_77978_p().func_74778_a("mobtype", "vertebrate");
                    stack.func_77978_p().func_74768_a("period", 2);
                } else if (this instanceof IArchiveInvertebrate) {
                    stackNBT = new NBTTagCompound();
                    entityNBT = new NBTTagCompound();
                    entityNBT.func_74778_a("id", "");
                    stackNBT.func_74782_a("PFMob", (NBTBase)entityNBT);
                    stack.func_77982_d(stackNBT);
                    stack.func_77978_p().func_74778_a("mobtype", "invertebrate");
                    stack.func_77978_p().func_74768_a("period", 2);
                } else if (this instanceof IArchiveStatic) {
                    stackNBT = new NBTTagCompound();
                    entityNBT = new NBTTagCompound();
                    entityNBT.func_74778_a("id", "");
                    stackNBT.func_74782_a("PFStatic", (NBTBase)entityNBT);
                    stack.func_77982_d(stackNBT);
                    stack.func_77978_p().func_74768_a("period", 2);
                } else if (this instanceof IArchivePlant) {
                    stackNBT = new NBTTagCompound();
                    entityNBT = new NBTTagCompound();
                    entityNBT.func_74778_a("id", "");
                    stackNBT.func_74782_a("PFPlant", (NBTBase)entityNBT);
                    stack.func_77982_d(stackNBT);
                    stack.func_77978_p().func_74768_a("period", 2);
                }
                BlockSkeletonBase.func_180635_a((World)world, (BlockPos)pos, (ItemStack)stack);
            }
            for (i = 0; i < ((TileEntityFossilBase)te).dim03; ++i) {
                --stages;
                stack = new ItemStack((Block)this, 1);
                if (this instanceof IArchiveVertebrate) {
                    stackNBT = new NBTTagCompound();
                    entityNBT = new NBTTagCompound();
                    entityNBT.func_74778_a("id", "");
                    stackNBT.func_74782_a("PFMob", (NBTBase)entityNBT);
                    stack.func_77982_d(stackNBT);
                    stack.func_77978_p().func_74778_a("mobtype", "vertebrate");
                    stack.func_77978_p().func_74768_a("period", 3);
                } else if (this instanceof IArchiveInvertebrate) {
                    stackNBT = new NBTTagCompound();
                    entityNBT = new NBTTagCompound();
                    entityNBT.func_74778_a("id", "");
                    stackNBT.func_74782_a("PFMob", (NBTBase)entityNBT);
                    stack.func_77982_d(stackNBT);
                    stack.func_77978_p().func_74778_a("mobtype", "invertebrate");
                    stack.func_77978_p().func_74768_a("period", 3);
                } else if (this instanceof IArchiveStatic) {
                    stackNBT = new NBTTagCompound();
                    entityNBT = new NBTTagCompound();
                    entityNBT.func_74778_a("id", "");
                    stackNBT.func_74782_a("PFStatic", (NBTBase)entityNBT);
                    stack.func_77982_d(stackNBT);
                    stack.func_77978_p().func_74768_a("period", 3);
                } else if (this instanceof IArchivePlant) {
                    stackNBT = new NBTTagCompound();
                    entityNBT = new NBTTagCompound();
                    entityNBT.func_74778_a("id", "");
                    stackNBT.func_74782_a("PFPlant", (NBTBase)entityNBT);
                    stack.func_77982_d(stackNBT);
                    stack.func_77978_p().func_74768_a("period", 3);
                }
                BlockSkeletonBase.func_180635_a((World)world, (BlockPos)pos, (ItemStack)stack);
            }
            for (i = 0; i < ((TileEntityFossilBase)te).dim04; ++i) {
                --stages;
                stack = new ItemStack((Block)this, 1);
                if (this instanceof IArchiveVertebrate) {
                    stackNBT = new NBTTagCompound();
                    entityNBT = new NBTTagCompound();
                    entityNBT.func_74778_a("id", "");
                    stackNBT.func_74782_a("PFMob", (NBTBase)entityNBT);
                    stack.func_77982_d(stackNBT);
                    stack.func_77978_p().func_74778_a("mobtype", "vertebrate");
                    stack.func_77978_p().func_74768_a("period", 4);
                } else if (this instanceof IArchiveInvertebrate) {
                    stackNBT = new NBTTagCompound();
                    entityNBT = new NBTTagCompound();
                    entityNBT.func_74778_a("id", "");
                    stackNBT.func_74782_a("PFMob", (NBTBase)entityNBT);
                    stack.func_77982_d(stackNBT);
                    stack.func_77978_p().func_74778_a("mobtype", "invertebrate");
                    stack.func_77978_p().func_74768_a("period", 4);
                } else if (this instanceof IArchiveStatic) {
                    stackNBT = new NBTTagCompound();
                    entityNBT = new NBTTagCompound();
                    entityNBT.func_74778_a("id", "");
                    stackNBT.func_74782_a("PFStatic", (NBTBase)entityNBT);
                    stack.func_77982_d(stackNBT);
                    stack.func_77978_p().func_74768_a("period", 4);
                } else if (this instanceof IArchivePlant) {
                    stackNBT = new NBTTagCompound();
                    entityNBT = new NBTTagCompound();
                    entityNBT.func_74778_a("id", "");
                    stackNBT.func_74782_a("PFPlant", (NBTBase)entityNBT);
                    stack.func_77982_d(stackNBT);
                    stack.func_77978_p().func_74768_a("period", 4);
                }
                BlockSkeletonBase.func_180635_a((World)world, (BlockPos)pos, (ItemStack)stack);
            }
            for (i = 0; i < ((TileEntityFossilBase)te).dim05; ++i) {
                --stages;
                stack = new ItemStack((Block)this, 1);
                if (this instanceof IArchiveVertebrate) {
                    stackNBT = new NBTTagCompound();
                    entityNBT = new NBTTagCompound();
                    entityNBT.func_74778_a("id", "");
                    stackNBT.func_74782_a("PFMob", (NBTBase)entityNBT);
                    stack.func_77982_d(stackNBT);
                    stack.func_77978_p().func_74778_a("mobtype", "vertebrate");
                    stack.func_77978_p().func_74768_a("period", 5);
                } else if (this instanceof IArchiveInvertebrate) {
                    stackNBT = new NBTTagCompound();
                    entityNBT = new NBTTagCompound();
                    entityNBT.func_74778_a("id", "");
                    stackNBT.func_74782_a("PFMob", (NBTBase)entityNBT);
                    stack.func_77982_d(stackNBT);
                    stack.func_77978_p().func_74778_a("mobtype", "invertebrate");
                    stack.func_77978_p().func_74768_a("period", 5);
                } else if (this instanceof IArchiveStatic) {
                    stackNBT = new NBTTagCompound();
                    entityNBT = new NBTTagCompound();
                    entityNBT.func_74778_a("id", "");
                    stackNBT.func_74782_a("PFStatic", (NBTBase)entityNBT);
                    stack.func_77982_d(stackNBT);
                    stack.func_77978_p().func_74768_a("period", 5);
                } else if (this instanceof IArchivePlant) {
                    stackNBT = new NBTTagCompound();
                    entityNBT = new NBTTagCompound();
                    entityNBT.func_74778_a("id", "");
                    stackNBT.func_74782_a("PFPlant", (NBTBase)entityNBT);
                    stack.func_77982_d(stackNBT);
                    stack.func_77978_p().func_74768_a("period", 5);
                }
                BlockSkeletonBase.func_180635_a((World)world, (BlockPos)pos, (ItemStack)stack);
            }
            for (i = 0; i < ((TileEntityFossilBase)te).dim06; ++i) {
                --stages;
                stack = new ItemStack((Block)this, 1);
                if (this instanceof IArchiveVertebrate) {
                    stackNBT = new NBTTagCompound();
                    entityNBT = new NBTTagCompound();
                    entityNBT.func_74778_a("id", "");
                    stackNBT.func_74782_a("PFMob", (NBTBase)entityNBT);
                    stack.func_77982_d(stackNBT);
                    stack.func_77978_p().func_74778_a("mobtype", "vertebrate");
                    stack.func_77978_p().func_74768_a("period", 6);
                } else if (this instanceof IArchiveInvertebrate) {
                    stackNBT = new NBTTagCompound();
                    entityNBT = new NBTTagCompound();
                    entityNBT.func_74778_a("id", "");
                    stackNBT.func_74782_a("PFMob", (NBTBase)entityNBT);
                    stack.func_77982_d(stackNBT);
                    stack.func_77978_p().func_74778_a("mobtype", "invertebrate");
                    stack.func_77978_p().func_74768_a("period", 6);
                } else if (this instanceof IArchiveStatic) {
                    stackNBT = new NBTTagCompound();
                    entityNBT = new NBTTagCompound();
                    entityNBT.func_74778_a("id", "");
                    stackNBT.func_74782_a("PFStatic", (NBTBase)entityNBT);
                    stack.func_77982_d(stackNBT);
                    stack.func_77978_p().func_74768_a("period", 6);
                } else if (this instanceof IArchivePlant) {
                    stackNBT = new NBTTagCompound();
                    entityNBT = new NBTTagCompound();
                    entityNBT.func_74778_a("id", "");
                    stackNBT.func_74782_a("PFPlant", (NBTBase)entityNBT);
                    stack.func_77982_d(stackNBT);
                    stack.func_77978_p().func_74768_a("period", 6);
                }
                BlockSkeletonBase.func_180635_a((World)world, (BlockPos)pos, (ItemStack)stack);
            }
            for (i = 0; i < ((TileEntityFossilBase)te).dim07; ++i) {
                --stages;
                stack = new ItemStack((Block)this, 1);
                if (this instanceof IArchiveVertebrate) {
                    stackNBT = new NBTTagCompound();
                    entityNBT = new NBTTagCompound();
                    entityNBT.func_74778_a("id", "");
                    stackNBT.func_74782_a("PFMob", (NBTBase)entityNBT);
                    stack.func_77982_d(stackNBT);
                    stack.func_77978_p().func_74778_a("mobtype", "vertebrate");
                    stack.func_77978_p().func_74768_a("period", 7);
                } else if (this instanceof IArchiveInvertebrate) {
                    stackNBT = new NBTTagCompound();
                    entityNBT = new NBTTagCompound();
                    entityNBT.func_74778_a("id", "");
                    stackNBT.func_74782_a("PFMob", (NBTBase)entityNBT);
                    stack.func_77982_d(stackNBT);
                    stack.func_77978_p().func_74778_a("mobtype", "invertebrate");
                    stack.func_77978_p().func_74768_a("period", 7);
                } else if (this instanceof IArchiveStatic) {
                    stackNBT = new NBTTagCompound();
                    entityNBT = new NBTTagCompound();
                    entityNBT.func_74778_a("id", "");
                    stackNBT.func_74782_a("PFStatic", (NBTBase)entityNBT);
                    stack.func_77982_d(stackNBT);
                    stack.func_77978_p().func_74768_a("period", 7);
                } else if (this instanceof IArchivePlant) {
                    stackNBT = new NBTTagCompound();
                    entityNBT = new NBTTagCompound();
                    entityNBT.func_74778_a("id", "");
                    stackNBT.func_74782_a("PFPlant", (NBTBase)entityNBT);
                    stack.func_77982_d(stackNBT);
                    stack.func_77978_p().func_74768_a("period", 7);
                }
                BlockSkeletonBase.func_180635_a((World)world, (BlockPos)pos, (ItemStack)stack);
            }
            for (i = 0; i < ((TileEntityFossilBase)te).dim08; ++i) {
                --stages;
                stack = new ItemStack((Block)this, 1);
                if (this instanceof IArchiveVertebrate) {
                    stackNBT = new NBTTagCompound();
                    entityNBT = new NBTTagCompound();
                    entityNBT.func_74778_a("id", "");
                    stackNBT.func_74782_a("PFMob", (NBTBase)entityNBT);
                    stack.func_77982_d(stackNBT);
                    stack.func_77978_p().func_74778_a("mobtype", "vertebrate");
                    stack.func_77978_p().func_74768_a("period", 8);
                } else if (this instanceof IArchiveInvertebrate) {
                    stackNBT = new NBTTagCompound();
                    entityNBT = new NBTTagCompound();
                    entityNBT.func_74778_a("id", "");
                    stackNBT.func_74782_a("PFMob", (NBTBase)entityNBT);
                    stack.func_77982_d(stackNBT);
                    stack.func_77978_p().func_74778_a("mobtype", "invertebrate");
                    stack.func_77978_p().func_74768_a("period", 8);
                } else if (this instanceof IArchiveStatic) {
                    stackNBT = new NBTTagCompound();
                    entityNBT = new NBTTagCompound();
                    entityNBT.func_74778_a("id", "");
                    stackNBT.func_74782_a("PFStatic", (NBTBase)entityNBT);
                    stack.func_77982_d(stackNBT);
                    stack.func_77978_p().func_74768_a("period", 8);
                } else if (this instanceof IArchivePlant) {
                    stackNBT = new NBTTagCompound();
                    entityNBT = new NBTTagCompound();
                    entityNBT.func_74778_a("id", "");
                    stackNBT.func_74782_a("PFPlant", (NBTBase)entityNBT);
                    stack.func_77982_d(stackNBT);
                    stack.func_77978_p().func_74768_a("period", 8);
                }
                BlockSkeletonBase.func_180635_a((World)world, (BlockPos)pos, (ItemStack)stack);
            }
            for (i = 0; i < ((TileEntityFossilBase)te).dim09; ++i) {
                --stages;
                stack = new ItemStack((Block)this, 1);
                if (this instanceof IArchiveVertebrate) {
                    stackNBT = new NBTTagCompound();
                    entityNBT = new NBTTagCompound();
                    entityNBT.func_74778_a("id", "");
                    stackNBT.func_74782_a("PFMob", (NBTBase)entityNBT);
                    stack.func_77982_d(stackNBT);
                    stack.func_77978_p().func_74778_a("mobtype", "vertebrate");
                    stack.func_77978_p().func_74768_a("period", 9);
                } else if (this instanceof IArchiveInvertebrate) {
                    stackNBT = new NBTTagCompound();
                    entityNBT = new NBTTagCompound();
                    entityNBT.func_74778_a("id", "");
                    stackNBT.func_74782_a("PFMob", (NBTBase)entityNBT);
                    stack.func_77982_d(stackNBT);
                    stack.func_77978_p().func_74778_a("mobtype", "invertebrate");
                    stack.func_77978_p().func_74768_a("period", 9);
                } else if (this instanceof IArchiveStatic) {
                    stackNBT = new NBTTagCompound();
                    entityNBT = new NBTTagCompound();
                    entityNBT.func_74778_a("id", "");
                    stackNBT.func_74782_a("PFStatic", (NBTBase)entityNBT);
                    stack.func_77982_d(stackNBT);
                    stack.func_77978_p().func_74768_a("period", 9);
                } else if (this instanceof IArchivePlant) {
                    stackNBT = new NBTTagCompound();
                    entityNBT = new NBTTagCompound();
                    entityNBT.func_74778_a("id", "");
                    stackNBT.func_74782_a("PFPlant", (NBTBase)entityNBT);
                    stack.func_77982_d(stackNBT);
                    stack.func_77978_p().func_74768_a("period", 9);
                }
                BlockSkeletonBase.func_180635_a((World)world, (BlockPos)pos, (ItemStack)stack);
            }
            for (i = 0; i < ((TileEntityFossilBase)te).dim10; ++i) {
                --stages;
                stack = new ItemStack((Block)this, 1);
                if (this instanceof IArchiveVertebrate) {
                    stackNBT = new NBTTagCompound();
                    entityNBT = new NBTTagCompound();
                    entityNBT.func_74778_a("id", "");
                    stackNBT.func_74782_a("PFMob", (NBTBase)entityNBT);
                    stack.func_77982_d(stackNBT);
                    stack.func_77978_p().func_74778_a("mobtype", "vertebrate");
                    stack.func_77978_p().func_74768_a("period", 10);
                } else if (this instanceof IArchiveInvertebrate) {
                    stackNBT = new NBTTagCompound();
                    entityNBT = new NBTTagCompound();
                    entityNBT.func_74778_a("id", "");
                    stackNBT.func_74782_a("PFMob", (NBTBase)entityNBT);
                    stack.func_77982_d(stackNBT);
                    stack.func_77978_p().func_74778_a("mobtype", "invertebrate");
                    stack.func_77978_p().func_74768_a("period", 10);
                } else if (this instanceof IArchiveStatic) {
                    stackNBT = new NBTTagCompound();
                    entityNBT = new NBTTagCompound();
                    entityNBT.func_74778_a("id", "");
                    stackNBT.func_74782_a("PFStatic", (NBTBase)entityNBT);
                    stack.func_77982_d(stackNBT);
                    stack.func_77978_p().func_74768_a("period", 10);
                } else if (this instanceof IArchivePlant) {
                    stackNBT = new NBTTagCompound();
                    entityNBT = new NBTTagCompound();
                    entityNBT.func_74778_a("id", "");
                    stackNBT.func_74782_a("PFPlant", (NBTBase)entityNBT);
                    stack.func_77982_d(stackNBT);
                    stack.func_77978_p().func_74768_a("period", 10);
                }
                BlockSkeletonBase.func_180635_a((World)world, (BlockPos)pos, (ItemStack)stack);
            }
            for (i = 0; i < ((TileEntityFossilBase)te).dim11; ++i) {
                --stages;
                stack = new ItemStack((Block)this, 1);
                if (this instanceof IArchiveVertebrate) {
                    stackNBT = new NBTTagCompound();
                    entityNBT = new NBTTagCompound();
                    entityNBT.func_74778_a("id", "");
                    stackNBT.func_74782_a("PFMob", (NBTBase)entityNBT);
                    stack.func_77982_d(stackNBT);
                    stack.func_77978_p().func_74778_a("mobtype", "vertebrate");
                    stack.func_77978_p().func_74768_a("period", 11);
                } else if (this instanceof IArchiveInvertebrate) {
                    stackNBT = new NBTTagCompound();
                    entityNBT = new NBTTagCompound();
                    entityNBT.func_74778_a("id", "");
                    stackNBT.func_74782_a("PFMob", (NBTBase)entityNBT);
                    stack.func_77982_d(stackNBT);
                    stack.func_77978_p().func_74778_a("mobtype", "invertebrate");
                    stack.func_77978_p().func_74768_a("period", 11);
                } else if (this instanceof IArchiveStatic) {
                    stackNBT = new NBTTagCompound();
                    entityNBT = new NBTTagCompound();
                    entityNBT.func_74778_a("id", "");
                    stackNBT.func_74782_a("PFStatic", (NBTBase)entityNBT);
                    stack.func_77982_d(stackNBT);
                    stack.func_77978_p().func_74768_a("period", 11);
                } else if (this instanceof IArchivePlant) {
                    stackNBT = new NBTTagCompound();
                    entityNBT = new NBTTagCompound();
                    entityNBT.func_74778_a("id", "");
                    stackNBT.func_74782_a("PFPlant", (NBTBase)entityNBT);
                    stack.func_77982_d(stackNBT);
                    stack.func_77978_p().func_74768_a("period", 11);
                }
                BlockSkeletonBase.func_180635_a((World)world, (BlockPos)pos, (ItemStack)stack);
            }
            for (i = 0; i < ((TileEntityFossilBase)te).dim12; ++i) {
                --stages;
                stack = new ItemStack((Block)this, 1);
                if (this instanceof IArchiveVertebrate) {
                    stackNBT = new NBTTagCompound();
                    entityNBT = new NBTTagCompound();
                    entityNBT.func_74778_a("id", "");
                    stackNBT.func_74782_a("PFMob", (NBTBase)entityNBT);
                    stack.func_77982_d(stackNBT);
                    stack.func_77978_p().func_74778_a("mobtype", "vertebrate");
                    stack.func_77978_p().func_74768_a("period", 12);
                } else if (this instanceof IArchiveInvertebrate) {
                    stackNBT = new NBTTagCompound();
                    entityNBT = new NBTTagCompound();
                    entityNBT.func_74778_a("id", "");
                    stackNBT.func_74782_a("PFMob", (NBTBase)entityNBT);
                    stack.func_77982_d(stackNBT);
                    stack.func_77978_p().func_74778_a("mobtype", "invertebrate");
                    stack.func_77978_p().func_74768_a("period", 12);
                } else if (this instanceof IArchiveStatic) {
                    stackNBT = new NBTTagCompound();
                    entityNBT = new NBTTagCompound();
                    entityNBT.func_74778_a("id", "");
                    stackNBT.func_74782_a("PFStatic", (NBTBase)entityNBT);
                    stack.func_77982_d(stackNBT);
                    stack.func_77978_p().func_74768_a("period", 12);
                } else if (this instanceof IArchivePlant) {
                    stackNBT = new NBTTagCompound();
                    entityNBT = new NBTTagCompound();
                    entityNBT.func_74778_a("id", "");
                    stackNBT.func_74782_a("PFPlant", (NBTBase)entityNBT);
                    stack.func_77982_d(stackNBT);
                    stack.func_77978_p().func_74768_a("period", 12);
                }
                BlockSkeletonBase.func_180635_a((World)world, (BlockPos)pos, (ItemStack)stack);
            }
            for (i = 0; i < ((TileEntityFossilBase)te).dim13; ++i) {
                --stages;
                stack = new ItemStack((Block)this, 1);
                if (this instanceof IArchiveVertebrate) {
                    stackNBT = new NBTTagCompound();
                    entityNBT = new NBTTagCompound();
                    entityNBT.func_74778_a("id", "");
                    stackNBT.func_74782_a("PFMob", (NBTBase)entityNBT);
                    stack.func_77982_d(stackNBT);
                    stack.func_77978_p().func_74778_a("mobtype", "vertebrate");
                    stack.func_77978_p().func_74768_a("period", 13);
                } else if (this instanceof IArchiveInvertebrate) {
                    stackNBT = new NBTTagCompound();
                    entityNBT = new NBTTagCompound();
                    entityNBT.func_74778_a("id", "");
                    stackNBT.func_74782_a("PFMob", (NBTBase)entityNBT);
                    stack.func_77982_d(stackNBT);
                    stack.func_77978_p().func_74778_a("mobtype", "invertebrate");
                    stack.func_77978_p().func_74768_a("period", 13);
                } else if (this instanceof IArchiveStatic) {
                    stackNBT = new NBTTagCompound();
                    entityNBT = new NBTTagCompound();
                    entityNBT.func_74778_a("id", "");
                    stackNBT.func_74782_a("PFStatic", (NBTBase)entityNBT);
                    stack.func_77982_d(stackNBT);
                    stack.func_77978_p().func_74768_a("period", 13);
                } else if (this instanceof IArchivePlant) {
                    stackNBT = new NBTTagCompound();
                    entityNBT = new NBTTagCompound();
                    entityNBT.func_74778_a("id", "");
                    stackNBT.func_74782_a("PFPlant", (NBTBase)entityNBT);
                    stack.func_77982_d(stackNBT);
                    stack.func_77978_p().func_74768_a("period", 13);
                }
                BlockSkeletonBase.func_180635_a((World)world, (BlockPos)pos, (ItemStack)stack);
            }
            for (i = 0; i < stages; ++i) {
                stack = new ItemStack((Block)this, 1);
                if (this instanceof IArchiveVertebrate) {
                    stackNBT = new NBTTagCompound();
                    entityNBT = new NBTTagCompound();
                    entityNBT.func_74778_a("id", "");
                    stackNBT.func_74782_a("PFMob", (NBTBase)entityNBT);
                    stack.func_77982_d(stackNBT);
                    stack.func_77978_p().func_74778_a("mobtype", "vertebrate");
                } else if (this instanceof IArchiveInvertebrate) {
                    stackNBT = new NBTTagCompound();
                    entityNBT = new NBTTagCompound();
                    entityNBT.func_74778_a("id", "");
                    stackNBT.func_74782_a("PFMob", (NBTBase)entityNBT);
                    stack.func_77982_d(stackNBT);
                    stack.func_77978_p().func_74778_a("mobtype", "invertebrate");
                } else if (this instanceof IArchiveStatic) {
                    stackNBT = new NBTTagCompound();
                    entityNBT = new NBTTagCompound();
                    entityNBT.func_74778_a("id", "");
                    stackNBT.func_74782_a("PFStatic", (NBTBase)entityNBT);
                    stack.func_77982_d(stackNBT);
                } else if (this instanceof IArchivePlant) {
                    stackNBT = new NBTTagCompound();
                    entityNBT = new NBTTagCompound();
                    entityNBT.func_74778_a("id", "");
                    stackNBT.func_74782_a("PFPlant", (NBTBase)entityNBT);
                    stack.func_77982_d(stackNBT);
                }
                BlockSkeletonBase.func_180635_a((World)world, (BlockPos)pos, (ItemStack)stack);
            }
        }
        if (te.getTileData().func_74764_b("frame") && te.getTileData().func_74767_n("frame")) {
            BlockSkeletonBase.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack(Blocks.field_150411_aY, 1));
        }
        world.func_175713_t(pos);
        super.func_180663_b(world, pos, state);
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tileEntity;
        super.func_180633_a(worldIn, pos, state, placer, stack);
        if (!worldIn.field_72995_K && (tileEntity = worldIn.func_175625_s(pos)) != null && tileEntity instanceof TileEntityFossilBase && ((TileEntityFossilBase)tileEntity).getStages() <= 1 && placer instanceof EntityPlayerMP && this.getModTrigger() != null) {
            this.getModTrigger().trigger((EntityPlayerMP)placer);
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        int newRotation;
        boolean hasFrame;
        TileEntity tileEntity;
        super.func_180639_a(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
        int newStage = this.getStage(worldIn, pos) + 1;
        if (!worldIn.field_72995_K && (tileEntity = worldIn.func_175625_s(pos)) != null && tileEntity instanceof TileEntityFossilBase) {
            hasFrame = false;
            if (tileEntity.getTileData() != null && tileEntity.getTileData().func_74764_b("frame")) {
                boolean bl = hasFrame = tileEntity.getTileData().func_74767_n("frame");
            }
            if (playerIn.func_184586_b(hand).func_77973_b() == Item.func_150898_a((Block)Blocks.field_150411_aY) && !hasFrame) {
                tileEntity.getTileData().func_74757_a("frame", true);
                SoundEvent soundevent = this.soundFrame();
                if (!playerIn.func_184812_l_()) {
                    playerIn.func_184586_b(hand).func_190918_g(1);
                }
                ((WorldServer)playerIn.func_130014_f_()).func_184133_a(null, pos, soundevent, SoundCategory.BLOCKS, 1.0f, 1.0f);
                return true;
            }
        }
        if (playerIn.func_70093_af() && !worldIn.field_72995_K && (tileEntity = worldIn.func_175625_s(pos)) != null && tileEntity instanceof TileEntityFossilBase) {
            hasFrame = false;
            if (tileEntity.getTileData() != null && tileEntity.getTileData().func_74764_b("frame")) {
                hasFrame = tileEntity.getTileData().func_74767_n("frame");
            }
            if (playerIn.func_184586_b(hand).func_190926_b() && hasFrame) {
                tileEntity.getTileData().func_74757_a("frame", false);
                ItemHandlerHelper.giveItemToPlayer((EntityPlayer)playerIn, (ItemStack)new ItemStack(Blocks.field_150411_aY, 1));
                return true;
            }
        }
        if (playerIn.func_184614_ca().func_77973_b() == Item.func_150898_a((Block)this) && !worldIn.field_72995_K) {
            tileEntity = worldIn.func_175625_s(pos);
            IBlockState blockstate = worldIn.func_180495_p(pos);
            if (tileEntity != null && tileEntity instanceof TileEntityFossilBase && ((TileEntityFossilBase)tileEntity).getStages() >= newStage) {
                tileEntity.getTileData().func_74768_a("stage", newStage);
                worldIn.func_184138_a(pos, blockstate, blockstate, 3);
                SoundEvent soundevent = this.soundPlace();
                ((WorldServer)playerIn.func_130014_f_()).func_184133_a(null, pos, soundevent, SoundCategory.BLOCKS, 1.0f, 1.0f);
                if (playerIn.func_184614_ca().func_77942_o() && playerIn.func_184614_ca().func_77978_p().func_74764_b("period")) {
                    switch (playerIn.func_184614_ca().func_77978_p().func_74762_e("period")) {
                        default: {
                            break;
                        }
                        case 1: {
                            ++((TileEntityFossilBase)tileEntity).dim01;
                            break;
                        }
                        case 2: {
                            ++((TileEntityFossilBase)tileEntity).dim02;
                            break;
                        }
                        case 3: {
                            ++((TileEntityFossilBase)tileEntity).dim03;
                            break;
                        }
                        case 4: {
                            ++((TileEntityFossilBase)tileEntity).dim04;
                            break;
                        }
                        case 5: {
                            ++((TileEntityFossilBase)tileEntity).dim05;
                            break;
                        }
                        case 6: {
                            ++((TileEntityFossilBase)tileEntity).dim06;
                            break;
                        }
                        case 7: {
                            ++((TileEntityFossilBase)tileEntity).dim07;
                            break;
                        }
                        case 8: {
                            ++((TileEntityFossilBase)tileEntity).dim08;
                            break;
                        }
                        case 9: {
                            ++((TileEntityFossilBase)tileEntity).dim09;
                            break;
                        }
                        case 10: {
                            ++((TileEntityFossilBase)tileEntity).dim10;
                            break;
                        }
                        case 11: {
                            ++((TileEntityFossilBase)tileEntity).dim11;
                            break;
                        }
                        case 12: {
                            ++((TileEntityFossilBase)tileEntity).dim12;
                            break;
                        }
                        case 13: {
                            ++((TileEntityFossilBase)tileEntity).dim13;
                        }
                    }
                    if (!playerIn.func_184812_l_()) {
                        playerIn.func_184614_ca().func_190918_g(1);
                    }
                }
                if (newStage == ((TileEntityFossilBase)tileEntity).getStages() && playerIn instanceof EntityPlayerMP && this.getModTrigger() != null) {
                    this.getModTrigger().trigger((EntityPlayerMP)playerIn);
                }
                return true;
            }
        }
        if ((newRotation = this.getRotation(worldIn, pos) + 15) >= 360) {
            newRotation = 0;
        }
        if (!worldIn.field_72995_K) {
            TileEntity tileEntity2 = worldIn.func_175625_s(pos);
            IBlockState blockstate = worldIn.func_180495_p(pos);
            if (tileEntity2 != null) {
                tileEntity2.getTileData().func_74768_a("rotation", newRotation);
            }
            worldIn.func_184138_a(pos, blockstate, blockstate, 3);
            SoundEvent soundevent = this.soundTurn();
            ((WorldServer)playerIn.func_130014_f_()).func_184133_a(null, pos, soundevent, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
        return true;
    }

    @Override
    @Nullable
    public CustomTrigger getModTrigger() {
        return null;
    }

    public ArrayList<Integer> dimAllowed() {
        ArrayList<Integer> dimArray = new ArrayList<Integer>();
        if (Arrays.stream(FossilBlockDrops.getPrecambrianDisplayableFossilDrops()).anyMatch(n -> ItemStack.func_77989_b((ItemStack)n, (ItemStack)new ItemStack((Block)this, 1)))) {
            dimArray.add(1);
        } else if (Arrays.stream(FossilBlockDrops.getPrecambrianDisplayableFossilDropsSlabs()).anyMatch(n -> ItemStack.func_77989_b((ItemStack)n, (ItemStack)new ItemStack((Block)this, 1)))) {
            dimArray.add(1);
        }
        if (Arrays.stream(FossilBlockDrops.getCambrianDisplayableFossilDrops()).anyMatch(n -> ItemStack.func_77989_b((ItemStack)n, (ItemStack)new ItemStack((Block)this, 1)))) {
            dimArray.add(2);
        } else if (Arrays.stream(FossilBlockDrops.getCambrianDisplayableFossilDropsSlabs()).anyMatch(n -> ItemStack.func_77989_b((ItemStack)n, (ItemStack)new ItemStack((Block)this, 1)))) {
            dimArray.add(2);
        }
        if (Arrays.stream(FossilBlockDrops.getOrdovicianDisplayableFossilDrops()).anyMatch(n -> ItemStack.func_77989_b((ItemStack)n, (ItemStack)new ItemStack((Block)this, 1)))) {
            dimArray.add(3);
        } else if (Arrays.stream(FossilBlockDrops.getOrdovicianDisplayableFossilDropsSlabs()).anyMatch(n -> ItemStack.func_77989_b((ItemStack)n, (ItemStack)new ItemStack((Block)this, 1)))) {
            dimArray.add(3);
        }
        if (Arrays.stream(FossilBlockDrops.getSilurianDisplayableFossilDrops()).anyMatch(n -> ItemStack.func_77989_b((ItemStack)n, (ItemStack)new ItemStack((Block)this, 1)))) {
            dimArray.add(4);
        } else if (Arrays.stream(FossilBlockDrops.getSilurianDisplayableFossilDropsSlabs()).anyMatch(n -> ItemStack.func_77989_b((ItemStack)n, (ItemStack)new ItemStack((Block)this, 1)))) {
            dimArray.add(4);
        }
        if (Arrays.stream(FossilBlockDrops.getDevonianDisplayableFossilDrops()).anyMatch(n -> ItemStack.func_77989_b((ItemStack)n, (ItemStack)new ItemStack((Block)this, 1)))) {
            dimArray.add(5);
        } else if (Arrays.stream(FossilBlockDrops.getDevonianDisplayableFossilDropsSlabs()).anyMatch(n -> ItemStack.func_77989_b((ItemStack)n, (ItemStack)new ItemStack((Block)this, 1)))) {
            dimArray.add(5);
        }
        if (Arrays.stream(FossilBlockDrops.getCarboniferousDisplayableFossilDrops()).anyMatch(n -> ItemStack.func_77989_b((ItemStack)n, (ItemStack)new ItemStack((Block)this, 1)))) {
            dimArray.add(6);
        } else if (Arrays.stream(FossilBlockDrops.getCarboniferousDisplayableFossilDropsSlabs()).anyMatch(n -> ItemStack.func_77989_b((ItemStack)n, (ItemStack)new ItemStack((Block)this, 1)))) {
            dimArray.add(6);
        }
        if (Arrays.stream(FossilBlockDrops.getPermianDisplayableFossilDrops()).anyMatch(n -> ItemStack.func_77989_b((ItemStack)n, (ItemStack)new ItemStack((Block)this, 1)))) {
            dimArray.add(7);
        } else if (Arrays.stream(FossilBlockDrops.getPermianDisplayableFossilDropsSlabs()).anyMatch(n -> ItemStack.func_77989_b((ItemStack)n, (ItemStack)new ItemStack((Block)this, 1)))) {
            dimArray.add(7);
        }
        if (Arrays.stream(FossilBlockDrops.getTriassicDisplayableFossilDrops()).anyMatch(n -> ItemStack.func_77989_b((ItemStack)n, (ItemStack)new ItemStack((Block)this, 1)))) {
            dimArray.add(8);
        } else if (Arrays.stream(FossilBlockDrops.getTriassicDisplayableFossilDropsSlabs()).anyMatch(n -> ItemStack.func_77989_b((ItemStack)n, (ItemStack)new ItemStack((Block)this, 1)))) {
            dimArray.add(8);
        }
        if (Arrays.stream(FossilBlockDrops.getJurassicDisplayableFossilDrops()).anyMatch(n -> ItemStack.func_77989_b((ItemStack)n, (ItemStack)new ItemStack((Block)this, 1)))) {
            dimArray.add(9);
        } else if (Arrays.stream(FossilBlockDrops.getJurassicDisplayableFossilDropsSlabs()).anyMatch(n -> ItemStack.func_77989_b((ItemStack)n, (ItemStack)new ItemStack((Block)this, 1)))) {
            dimArray.add(9);
        }
        if (Arrays.stream(FossilBlockDrops.getCretaceousDisplayableFossilDrops()).anyMatch(n -> ItemStack.func_77989_b((ItemStack)n, (ItemStack)new ItemStack((Block)this, 1)))) {
            dimArray.add(10);
        } else if (Arrays.stream(FossilBlockDrops.getCretaceousDisplayableFossilDropsSlabs()).anyMatch(n -> ItemStack.func_77989_b((ItemStack)n, (ItemStack)new ItemStack((Block)this, 1)))) {
            dimArray.add(10);
        }
        if (Arrays.stream(FossilBlockDrops.getPaleogeneDisplayableFossilDrops()).anyMatch(n -> ItemStack.func_77989_b((ItemStack)n, (ItemStack)new ItemStack((Block)this, 1)))) {
            dimArray.add(11);
        } else if (Arrays.stream(FossilBlockDrops.getPaleogeneDisplayableFossilDropsSlabs()).anyMatch(n -> ItemStack.func_77989_b((ItemStack)n, (ItemStack)new ItemStack((Block)this, 1)))) {
            dimArray.add(11);
        }
        if (Arrays.stream(FossilBlockDrops.getNeogeneDisplayableFossilDrops()).anyMatch(n -> ItemStack.func_77989_b((ItemStack)n, (ItemStack)new ItemStack((Block)this, 1)))) {
            dimArray.add(12);
        } else if (Arrays.stream(FossilBlockDrops.getNeogeneDisplayableFossilDropsSlabs()).anyMatch(n -> ItemStack.func_77989_b((ItemStack)n, (ItemStack)new ItemStack((Block)this, 1)))) {
            dimArray.add(12);
        }
        if (Arrays.stream(FossilBlockDrops.getPleistoceneDisplayableFossilDrops()).anyMatch(n -> ItemStack.func_77989_b((ItemStack)n, (ItemStack)new ItemStack((Block)this, 1)))) {
            dimArray.add(13);
        } else if (Arrays.stream(FossilBlockDrops.getPleistoceneDisplayableFossilDropsSlabs()).anyMatch(n -> ItemStack.func_77989_b((ItemStack)n, (ItemStack)new ItemStack((Block)this, 1)))) {
            dimArray.add(13);
        }
        return dimArray;
    }
}

