/*
 * Decompiled with CFR 0.152.
 */
package net.prehistoricnaturefossils.blocks.base;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.prehistoricnaturefossils.PrehistoricNatureFossils;
import net.prehistoricnaturefossils.items.IHasModel;

public abstract class BlockSkullBase
extends Block
implements IHasModel {
    public static final PropertyDirection FACING = BlockDirectional.field_176387_N;

    public BlockSkullBase() {
        super(Material.field_151576_e);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149711_c(1.5f);
        this.func_149752_b(6.0f);
        this.func_149715_a(0.0f);
        this.func_149713_g(0);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.UP));
        this.func_149647_a(PrehistoricNatureFossils.CREATIVE_TAB);
    }

    public SoundEvent soundPlace() {
        return SoundEvents.field_187843_fX;
    }

    public SoundEvent soundTurn() {
        return SoundEvents.field_187843_fX;
    }

    @Nullable
    public String getDNACompat() {
        return null;
    }

    @Override
    public void registerModels() {
        PrehistoricNatureFossils.proxy.registerItemRenderer(Item.func_150898_a((Block)this), 0, "inventory");
    }

    public int getRotation(World world, BlockPos pos) {
        int currentRotation = 0;
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity != null && tileEntity.getTileData().func_74764_b("rotation")) {
            currentRotation = tileEntity.getTileData().func_74762_e("rotation");
        }
        return currentRotation;
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return true;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public boolean func_189539_a(IBlockState state, World worldIn, BlockPos pos, int eventID, int eventParam) {
        super.func_189539_a(state, worldIn, pos, eventID, eventParam);
        TileEntity tileentity = worldIn.func_175625_s(pos);
        return tileentity == null ? false : tileentity.func_145842_c(eventID, eventParam);
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_82600_a((int)meta));
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return new ItemStack(Items.field_190931_a, 1).func_77973_b();
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.field_72995_K) {
            EntityItem entityToSpawn = new EntityItem(worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), new ItemStack((Block)this, 1));
            entityToSpawn.func_174867_a(10);
            worldIn.func_72838_d((Entity)entityToSpawn);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing);
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        super.func_176213_c(world, pos, state);
        if (!world.field_72995_K) {
            TileEntity tileEntity = world.func_175625_s(pos);
            IBlockState blockstate = world.func_180495_p(pos);
            if (tileEntity != null) {
                tileEntity.getTileData().func_74768_a("rotation", 0);
            }
            world.func_184138_a(pos, blockstate, blockstate, 3);
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        super.func_180639_a(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
        int newRotation = this.getRotation(worldIn, pos) + 15;
        if (newRotation >= 360) {
            newRotation = 0;
        }
        if (!worldIn.field_72995_K) {
            TileEntity tileEntity = worldIn.func_175625_s(pos);
            IBlockState blockstate = worldIn.func_180495_p(pos);
            if (tileEntity != null) {
                tileEntity.getTileData().func_74768_a("rotation", newRotation);
            }
            worldIn.func_184138_a(pos, blockstate, blockstate, 3);
            SoundEvent soundevent = this.soundTurn();
            ((WorldServer)playerIn.func_130014_f_()).func_184133_a(null, pos, soundevent, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
        return true;
    }
}

