/*
 * Decompiled with CFR 0.152.
 */
package com.anionianonion.sangriafy;

import com.anionianonion.sangriafy.ClientConfig;
import com.anionianonion.sangriafy.Helpers;
import com.anionianonion.sangriafy.NaturalLanguageHelper;
import com.anionianonion.sangriafy.SangriafyMod;
import com.anionianonion.sangriafy.ServerConfig;
import com.anionianonion.sangriafy.network.ModMessages;
import com.anionianonion.sangriafy.network.packets.SetSangriaStatesPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.client.event.ClientChatEvent;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="sangriafy", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class EventHandler {
    private static boolean enabled = true;

    @SubscribeEvent
    public static void chat(ClientChatEvent e) {
        String chatCommandSangriaPrefix;
        String originalMessage = e.getOriginalMessage();
        if (originalMessage.startsWith(chatCommandSangriaPrefix = ".sangriafy")) {
            if (originalMessage.equals(chatCommandSangriaPrefix)) {
                enabled = !enabled;
            } else if (originalMessage.equals(chatCommandSangriaPrefix + " -r")) {
                ClientConfig.enableReplaceAndWithAmpersands = !ClientConfig.enableReplaceAndWithAmpersands;
            } else if (originalMessage.equals(chatCommandSangriaPrefix + " -np")) {
                ClientConfig.enableNoPeriodsAfterAbbreviations = !ClientConfig.enableNoPeriodsAfterAbbreviations;
            } else if (originalMessage.startsWith(chatCommandSangriaPrefix + " -pnl")) {
                try {
                    ClientConfig.protectedNumLetters = Integer.parseInt(originalMessage.split("-pnl")[1].strip());
                }
                catch (NumberFormatException nfe) {
                    SangriafyMod.LOGGER.error("NaN when setting number of letters to leave untouched.");
                }
            }
            if (EventHandler.serverHasThisMod()) {
                ModMessages.sendToServer(new SetSangriaStatesPacket(enabled, ClientConfig.enableNoPeriodsAfterAbbreviations, ClientConfig.enableReplaceAndWithAmpersands));
            }
            e.setCanceled(true);
        } else if (enabled && !EventHandler.serverHasThisMod()) {
            NaturalLanguageHelper nlh = new NaturalLanguageHelper();
            String newMessage = nlh.getSANGRIA(e.getOriginalMessage());
            e.setMessage(newMessage);
        } else {
            e.setMessage(e.getOriginalMessage());
        }
    }

    @SubscribeEvent
    public static void serverChat(ServerChatEvent e) {
        CompoundTag sangriaData;
        if (!EventHandler.serverHasThisMod()) {
            if (ClientConfig.enableDebugging) {
                SangriafyMod.LOGGER.info("server doesn't have the SANGRIA mod");
            }
            return;
        }
        if (!EventHandler.clientHasThisMod()) {
            if (ServerConfig.enableDebugging) {
                SangriafyMod.LOGGER.info(String.format("client %s doesn't have the SANGRIA mod", e.getPlayer().m_5446_()));
            }
            return;
        }
        CompoundTag persistentData = e.getPlayer().getPersistentData().m_128469_("PlayerPersisted");
        if (persistentData.m_128441_("SANGRIA_data")) {
            sangriaData = persistentData.m_128469_("SANGRIA_data");
        } else {
            sangriaData = Helpers.createSANGRIAcompoundTag(true, true, false);
            persistentData.m_128365_("SANGRIA_data", (Tag)sangriaData);
        }
        if (!sangriaData.m_128471_("isEnabled")) {
            if (ServerConfig.enableDebugging) {
                SangriafyMod.LOGGER.info("Player %s doesn't have a SANGRIAfy enabled flag.");
            }
            return;
        }
        String messageAsString = e.getMessage().getString();
        if (messageAsString.length() <= ServerConfig.protectedNumLetters) {
            return;
        }
        NaturalLanguageHelper nlh = new NaturalLanguageHelper();
        String sangria = nlh.getSANGRIA(messageAsString);
        MutableComponent sangriaComponent = Component.m_237113_((String)sangria).m_130938_(style -> style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)e.getMessage())));
        e.setMessage((Component)sangriaComponent);
    }

    public static boolean serverHasThisMod() {
        boolean compatibility;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.m_91403_() == null) {
            if (ClientConfig.enableDebugging) {
                SangriafyMod.LOGGER.info("mc.getConnection() is null");
            }
            return false;
        }
        if (mc.m_91091_()) {
            if (ClientConfig.enableDebugging) {
                SangriafyMod.LOGGER.info("mc.hasSinglePlayerServer() is true.");
            }
            return true;
        }
        ServerData serverData = mc.m_91403_().m_245416_();
        if (serverData == null) {
            if (ClientConfig.enableDebugging) {
                SangriafyMod.LOGGER.info("serverData is null");
            }
            return false;
        }
        boolean a = "FML".equals(serverData.forgeData.type());
        boolean b = serverData.forgeData.isCompatible();
        boolean bl = compatibility = a && b;
        if (ClientConfig.enableDebugging) {
            SangriafyMod.LOGGER.info(String.format("a: %s", a));
            SangriafyMod.LOGGER.info(String.format("b: %s", b));
            SangriafyMod.LOGGER.info(String.format("is server compatible: %s", compatibility));
        }
        return compatibility;
    }

    public static boolean clientHasThisMod() {
        return ModList.get().isLoaded("sangriafy");
    }
}

