/*
 * Decompiled with CFR 0.152.
 */
package com.anionianonion.sangriafy.network.packets;

import com.anionianonion.sangriafy.Helpers;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class SetSangriaStatesPacket {
    private final boolean isEnabled;
    private final boolean noPeriodsAfterAbbreviations;
    private final boolean replaceAndsWithAmpersands;

    public SetSangriaStatesPacket(boolean isEnabled, boolean noPeriodsAfterAbbreviations, boolean replaceAndsWithAmpersands) {
        this.isEnabled = isEnabled;
        this.noPeriodsAfterAbbreviations = noPeriodsAfterAbbreviations;
        this.replaceAndsWithAmpersands = replaceAndsWithAmpersands;
    }

    public static void encode(SetSangriaStatesPacket packet, FriendlyByteBuf buf) {
        buf.writeBoolean(packet.isEnabled);
        buf.writeBoolean(packet.noPeriodsAfterAbbreviations);
        buf.writeBoolean(packet.replaceAndsWithAmpersands);
    }

    public static SetSangriaStatesPacket decode(FriendlyByteBuf buf) {
        boolean isEnabled = buf.readBoolean();
        boolean noPeriodsAfterAbbrevations = buf.readBoolean();
        boolean replaceAndsWithAmpersands = buf.readBoolean();
        return new SetSangriaStatesPacket(isEnabled, noPeriodsAfterAbbrevations, replaceAndsWithAmpersands);
    }

    public static void handle(SetSangriaStatesPacket packet, Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            ServerPlayer serverPlayer = context.getSender();
            CompoundTag persistentData = serverPlayer.getPersistentData().m_128469_("PlayerPersisted");
            CompoundTag sangriaData = Helpers.createSANGRIAcompoundTag(packet.isEnabled, packet.noPeriodsAfterAbbreviations, packet.replaceAndsWithAmpersands);
            persistentData.m_128365_("SANGRIA_data", (Tag)sangriaData);
        });
        context.setPacketHandled(true);
    }
}

