/*
 * Decompiled with CFR 0.152.
 */
package com.anionianonion.sangriafy;

import com.anionianonion.sangriafy.ChatHelpers;
import com.anionianonion.sangriafy.ClientConfig;
import com.anionianonion.sangriafy.NaturalLanguageHelper;
import com.anionianonion.sangriafy.SangriafyMod;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.client.event.ClientChatEvent;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="sangriafy", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class EventHandler {
    private static boolean enabled = true;

    @SubscribeEvent
    public static void chat(ClientChatEvent e) {
        String chatCommandSangriaPrefix;
        String originalMessage = e.getOriginalMessage();
        if (originalMessage.startsWith(chatCommandSangriaPrefix = ".sangriafy")) {
            if (originalMessage.equals(chatCommandSangriaPrefix)) {
                enabled = !enabled;
            } else if (originalMessage.equals(chatCommandSangriaPrefix + " -r")) {
                ClientConfig.enableReplaceAndWithAmpersands = !ClientConfig.enableReplaceAndWithAmpersands;
            } else if (originalMessage.equals(chatCommandSangriaPrefix + " -np")) {
                ClientConfig.enableNoPeriodsAfterAbbreviations = !ClientConfig.enableNoPeriodsAfterAbbreviations;
            } else if (originalMessage.startsWith(chatCommandSangriaPrefix + " -pnl")) {
                try {
                    ClientConfig.protectedNumLetters = Integer.parseInt(originalMessage.split("-pnl")[1].strip());
                }
                catch (NumberFormatException nfe) {
                    SangriafyMod.LOGGER.error("NaN when setting number of letters to leave untouched.");
                }
            }
            e.setCanceled(true);
        } else if (enabled && !EventHandler.serverHasThisMod()) {
            NaturalLanguageHelper nlh = new NaturalLanguageHelper();
            String newMessage = nlh.getSANGRIA(e.getOriginalMessage());
            e.setMessage(newMessage);
        } else {
            e.setMessage(e.getOriginalMessage());
        }
    }

    @SubscribeEvent
    public static void onClientReceiveChat(ClientChatReceivedEvent e) {
        if (e.isSystem()) {
            return;
        }
        if (!EventHandler.serverHasThisMod()) {
            return;
        }
        if (!enabled) {
            return;
        }
        List<Component> msgParts = ChatHelpers.getMessageComponents(e);
        NaturalLanguageHelper nlh = new NaturalLanguageHelper();
        String sangria = nlh.getSANGRIA(msgParts.get(1).getString());
        MutableComponent sangriaComponent = Component.m_237113_((String)sangria).m_130938_(style -> style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)((Component)msgParts.get(1)))));
        MutableComponent completeMessage = msgParts.get(0).m_6881_().m_7220_((Component)sangriaComponent);
        e.setMessage((Component)completeMessage);
    }

    public static boolean serverHasThisMod() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.m_91403_() == null) {
            return false;
        }
        if (mc.m_91091_()) {
            return true;
        }
        ServerData serverData = mc.m_91403_().m_245416_();
        if (serverData == null) {
            return false;
        }
        return "FML".equals(serverData.forgeData.type()) && serverData.forgeData.isCompatible();
    }
}

