/*
 * Decompiled with CFR 0.152.
 */
package com.anionianonion.sangriafy;

import com.anionianonion.sangriafy.ClientConfig;
import java.util.HashSet;
import java.util.Set;

public class NaturalLanguageHelper {
    private Set<String> conjunctions = Set.of("for", "and", "nor", "but", "or", "yet", "so");
    private Set<Character> punctuations = Set.of(Character.valueOf('.'), Character.valueOf('!'), Character.valueOf('?'), Character.valueOf(','));

    public Set<String> getConjunctions() {
        return this.conjunctions;
    }

    public void setConjunctions(Set<String> conjunctions) {
        this.conjunctions = conjunctions;
    }

    public Set<Character> getPunctuations() {
        return this.punctuations;
    }

    public void setPunctuations(Set<Character> punctuations) {
        this.punctuations = punctuations;
    }

    public int getIndexOfFirstPunctuation(String message) {
        HashSet<Character> usedPunctuation = new HashSet<Character>();
        for (Character character : this.punctuations) {
            if (message.indexOf(character.charValue()) == -1) continue;
            usedPunctuation.add(character);
        }
        int index = -1;
        for (Character usedCharacter : usedPunctuation) {
            if (index == -1) {
                index = message.indexOf(usedCharacter.charValue());
                continue;
            }
            index = Math.min(index, message.indexOf(usedCharacter.charValue()));
        }
        return index;
    }

    public String getSANGRIA(String message) {
        int index;
        StringBuilder newMessage = new StringBuilder();
        Set<String> conjunctions = this.getConjunctions();
        if (message.length() <= ClientConfig.protectedNumLetters) {
            return message;
        }
        do {
            String[] words;
            String partialSentence = (index = this.getIndexOfFirstPunctuation(message)) != -1 ? message.substring(0, index).strip() : message;
            String punctuation = index != -1 ? message.substring(index, index + 1) : ".";
            for (String word : words = partialSentence.split("\\s+")) {
                if (!conjunctions.contains(word)) {
                    String initial = word.substring(0, 1).toUpperCase();
                    initial = initial.toUpperCase();
                    newMessage.append(initial);
                    String finalWord = words[words.length - 1];
                    if (ClientConfig.enableNoPeriodsAfterAbbreviations || word.equals(finalWord)) continue;
                    newMessage.append(".");
                    continue;
                }
                if (word.equals("and") && ClientConfig.enableReplaceAndWithAmpersands) {
                    word = "&";
                }
                newMessage.append(" ").append(word).append(" ");
            }
            newMessage.append(punctuation).append(" ");
        } while (!(message = index != -1 ? message.substring(index + 1).strip() : "").isEmpty());
        return newMessage.toString();
    }
}

