/*
 * Decompiled with CFR 0.152.
 */
package com.fireblaze.exhausted.Sounds;

import com.fireblaze.exhausted.Sounds.ModSounds;
import com.fireblaze.exhausted.config.Settings;
import java.util.ArrayDeque;
import java.util.Queue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.AbstractSoundInstance;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.sounds.SoundEvent;

public class ClientSoundHandler {
    private static int currentThreshold = -1;
    private static AbstractSoundInstance currentSound;
    private static final Queue<Integer> pendingThresholds;

    public static void playThresholdSound(int newThreshold) {
        SoundEvent soundEvent = ClientSoundHandler.getSoundEvent(newThreshold);
        if (soundEvent == null && newThreshold != -1) {
            System.out.println("NEGATIVE_" + newThreshold + " noch nicht registriert, in Queue setzen!");
            pendingThresholds.add(newThreshold);
            Minecraft.m_91087_().execute(ClientSoundHandler::tryPendingSounds);
            return;
        }
        if (newThreshold >= 0) {
            ClientSoundHandler.playSound(soundEvent, newThreshold);
        }
        currentThreshold = newThreshold;
    }

    private static void tryPendingSounds() {
        int threshold;
        SoundEvent soundEvent;
        while (!pendingThresholds.isEmpty() && (soundEvent = ClientSoundHandler.getSoundEvent(threshold = pendingThresholds.peek().intValue())) != null) {
            pendingThresholds.poll();
            ClientSoundHandler.playSound(soundEvent, threshold);
            currentThreshold = threshold;
        }
    }

    private static SoundEvent getSoundEvent(int threshold) {
        return switch (threshold) {
            case 0 -> {
                if (ModSounds.NEGATIVE_1.isPresent()) {
                    yield (SoundEvent)ModSounds.NEGATIVE_1.get();
                }
                yield null;
            }
            case 1, 2 -> {
                if (ModSounds.NEGATIVE_2.isPresent()) {
                    yield (SoundEvent)ModSounds.NEGATIVE_2.get();
                }
                yield null;
            }
            default -> null;
        };
    }

    private static void playSound(SoundEvent soundEvent, int threshold) {
        if (!Settings.getBreathVolume()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        SoundManager manager = mc.m_91106_();
        if (threshold > currentThreshold || currentThreshold == -1) {
            if (currentSound != null) {
                manager.m_120399_((SoundInstance)currentSound);
                currentSound = null;
            }
            currentSound = SimpleSoundInstance.m_119766_((SoundEvent)soundEvent, (float)1.0f, (float)1.0f);
            mc.m_91106_().m_120367_((SoundInstance)currentSound);
        }
    }

    static {
        pendingThresholds = new ArrayDeque<Integer>();
    }
}

