/*
 * Decompiled with CFR 0.152.
 */
package com.fireblaze.exhausted;

import com.fireblaze.exhausted.ModEvents;
import com.fireblaze.exhausted.Sounds.ModSounds;
import com.fireblaze.exhausted.comfort.ComfortEvents;
import com.fireblaze.exhausted.commands.StaminaCommands;
import com.fireblaze.exhausted.config.StaminaConfig;
import com.fireblaze.exhausted.entity.ModEntities;
import com.fireblaze.exhausted.events.PlayerSleepHandler;
import com.fireblaze.exhausted.events.PlayerTickHandler;
import com.fireblaze.exhausted.items.ModItems;
import com.fireblaze.exhausted.networking.ModMessages;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="exhausted")
public class StaminaMod {
    public static final String MODID = "exhausted";
    private static final Logger LOGGER = LogUtils.getLogger();

    public StaminaMod(FMLJavaModLoadingContext context) {
        IEventBus modEventBus = context.getModEventBus();
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::addCreative);
        ModEntities.ENTITIES.register(modEventBus);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register(PlayerTickHandler.class);
        PlayerSleepHandler.register();
        MinecraftForge.EVENT_BUS.register((Object)new ModEvents());
        MinecraftForge.EVENT_BUS.register((Object)new ComfortEvents());
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)StaminaConfig.SPEC);
        ModSounds.register(FMLJavaModLoadingContext.get().getModEventBus());
        ModItems.register(modEventBus);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {});
        ModMessages.register();
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.f_256797_) {
            event.accept(ModItems.STEPUP_BOOTS);
        }
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
    }

    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
    }

    @Mod.EventBusSubscriber(modid="exhausted", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
        }
    }

    @Mod.EventBusSubscriber(modid="stamina_mod")
    public class CommandEvents {
        @SubscribeEvent
        public static void onRegisterCommands(RegisterCommandsEvent event) {
            StaminaCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        }
    }
}

