/*
 * Decompiled with CFR 0.152.
 */
package com.fireblaze.exhausted.comfort;

import com.fireblaze.exhausted.comfort.ComfortHelper;
import com.fireblaze.exhausted.config.Settings;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;

public class ComfortCalculator {
    public static ComfortResult calculateComfort(ServerLevel level, Player player) {
        double malus;
        double bonus;
        double comfort = 0.0;
        ComfortResult result = new ComfortResult(0.0);
        StringBuilder string = new StringBuilder();
        if (player.m_7500_() || player.m_5833_()) {
            result.comfort = 999999.0;
            return result;
        }
        if (Settings.getComfortBonus("walls") != 0.0) {
            if (ComfortHelper.hasDecoratedWalls(level, player)) {
                bonus = Settings.getComfortBonus("walls");
                comfort += bonus;
                string.append("Has deco walls +").append(bonus).append("\n");
            } else {
                result.issues.add("no_deco_walls");
            }
        }
        if (Settings.getComfortBonus("ceiling") != 0.0) {
            if (ComfortHelper.hasCeilingHeight(level, player, 2)) {
                bonus = Settings.getComfortBonus("ceiling");
                comfort += bonus;
                string.append("Has ceiling +").append(bonus).append("\n");
            } else {
                result.issues.add("low_ceiling");
            }
        }
        if (Settings.getComfortBonus("space") != 0.0) {
            if (ComfortHelper.hasEnoughSpace(level, player, 24)) {
                bonus = Settings.getComfortBonus("space");
                comfort += bonus;
                string.append("Has enough space +").append(bonus).append("\n");
            } else {
                result.issues.add("no_space");
            }
        }
        if (Settings.getComfortBonus("light") != 0.0) {
            if (ComfortHelper.hasGoodLighting(player)) {
                bonus = Settings.getComfortBonus("light");
                comfort += bonus;
                string.append("Has good lighting +").append(bonus).append("\n");
            } else {
                result.issues.add("dark");
            }
        }
        if (Settings.getComfortBonus("animal") != 0.0) {
            if (ComfortHelper.hasFriendlyAnimalNearby(level, player)) {
                bonus = Settings.getComfortBonus("animal");
                comfort += bonus;
                string.append("Animal nearby +").append(bonus).append("\n");
            } else {
                result.issues.add("lonely");
            }
        }
        if (Settings.getComfortBonus("food") != 0.0) {
            if (ComfortHelper.chestWithFoodNearby(level, player)) {
                bonus = Settings.getComfortBonus("food");
                comfort += bonus;
                string.append("Food around +").append(bonus).append("\n");
            } else {
                result.issues.add("no_food_stock");
            }
        }
        double blockCount = ComfortHelper.countComfortBlocks(level, player);
        double blockBonus = Math.min(Settings.getComfortBonus("block_max"), blockCount * Settings.getComfortBonus("block_per"));
        comfort += blockBonus;
        string.append("Comfort blocks: ").append(blockCount).append(" => +").append(blockBonus).append("%\n");
        result.issues.add("no_comfort_blocks");
        if (ComfortHelper.hasBoostBlock(level, player)) {
            double bonus2 = Settings.getComfortBonus("boost_block");
            comfort += bonus2;
            string.append("Boost block present +").append(bonus2).append("\n");
            result.issues.add("no_boost_block");
        }
        if (player.m_20070_()) {
            malus = Settings.getComfortMalus("in_rain");
            comfort += malus;
            string.append("Wet ").append(malus).append("\n");
            result.issues.add("wet");
        }
        if (player.m_36325_()) {
            malus = Settings.getComfortMalus("hurt");
            comfort += malus;
            string.append("Hurt ").append(malus).append("\n");
            result.issues.add("hurt");
        }
        if (player.m_36324_().m_38702_() < 16) {
            malus = Settings.getComfortMalus("hungry");
            comfort += malus;
            string.append("Hungry ").append(malus).append("\n");
            result.issues.add("hungry");
        }
        if (Settings.getComfortMalus("dimension") != 0.0 && !level.m_46472_().m_135782_().toString().equals("minecraft:overworld")) {
            malus = Settings.getComfortMalus("dimension");
            comfort += malus;
            string.append("Not in Overworld ").append(malus).append("\n");
            result.issues.add("foreign_dimension");
        }
        if (Settings.getComfortMalus("monsters") != 0.0 && ComfortHelper.monstersNearby(level, player)) {
            malus = Settings.getComfortMalus("monsters");
            comfort += malus;
            string.append("Monsters around ").append(malus).append("\n");
            result.issues.add("monsters");
        }
        result.comfort = comfort;
        return result;
    }

    public static class ComfortResult {
        public double comfort;
        public final List<String> issues = new ArrayList<String>();

        public ComfortResult(double comfort) {
            this.comfort = comfort;
        }
    }
}

