/*
 * Decompiled with CFR 0.152.
 */
package com.fireblaze.exhausted.comfort;

import com.fireblaze.exhausted.comfort.ComfortCapability;
import com.fireblaze.exhausted.comfort.ComfortProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="exhausted")
public class ComfortEvents {
    @SubscribeEvent
    public static void onRegisterCapabilities(RegisterCapabilitiesEvent event) {
        event.register(ComfortCapability.class);
    }

    @SubscribeEvent
    public static void onAttachCapabilitiesPlayer(AttachCapabilitiesEvent<Entity> event) {
        Player player;
        Object object = event.getObject();
        if (object instanceof Player && !(player = (Player)object).getCapability(ComfortProvider.COMFORT_CAP).isPresent()) {
            event.addCapability(ResourceLocation.fromNamespaceAndPath((String)"exhausted", (String)"comfort"), (ICapabilityProvider)new ComfortProvider());
        }
    }

    @SubscribeEvent
    public static void onPlayerCloned(PlayerEvent.Clone event) {
        if (event.isWasDeath()) {
            event.getOriginal().reviveCaps();
            event.getOriginal().getCapability(ComfortProvider.COMFORT_CAP).ifPresent(oldCap -> event.getEntity().getCapability(ComfortProvider.COMFORT_CAP).ifPresent(newCap -> {
                newCap.setSitting(oldCap.isSitting());
                newCap.setComfortLevel(oldCap.getComfortLevel());
            }));
            event.getOriginal().invalidateCaps();
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
    }
}

